<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class CommunitySurveysControllerQuestions extends JControllerForm
{
	protected $text_prefix = 'COM_COMMUNITYSURVEYS';
	protected $base_path   = CS_LAYOUTS_BASE_PATH;
	
	public function __construct ($config = array())
	{
		parent::__construct($config);
	}

	public function save($key = null, $urlVar = 'qid')
	{
		$app                                          = JFactory::getApplication();

		// first create or update the question itself
		$question							          = new stdClass();
		$question->title                              = JComponentHelper::filterText($this->input->post->get('title', '', 'raw'));
		$question->id                                 = $this->input->post->get('qid', 0, 'uint');
		$question->survey_id                          = $this->input->post->get('survey_id', 0, 'uint');
		$question->question_type                      = $this->input->post->get('qtype', 0, 'uint');
		$question->page_number                        = $this->input->post->get('pid', 0, 'uint');
		$question->sort_order                         = $this->input->post->get('sort_order', 0, 'uint');
		$question->mandatory                          = $this->input->post->get('mandatory', 0, 'boolean');
		$question->custom_choice                      = $this->input->post->get('custom_choice', 0, 'boolean');
		$question->orientation                        = $this->input->post->get('orientation', false, 'boolean');
		$question->description                        = JComponentHelper::filterText($this->input->post->get('description', '', 'raw'));
		$question->orientation                        = $question->orientation ? 'IL' : 'RW';
		$question->min_selections                     = $this->input->post->get('min_selections', 0, 'uint');
		$question->max_selections                     = $this->input->post->get('max_selections', 0, 'uint');

		$questionParams	                              = new stdClass();
		$questionParams->autofill_email               = $this->input->post->get('autofill_email', 0, 'int');
		$questionParams->autofill_name                = $this->input->post->get('autofill_name', 0, 'int');
		$questionParams->question_class               = $this->input->post->get('question_class', '', 'string');
		$questionParams->date_format                  = $this->input->post->get('date_format', '', 'string');
		$questionParams->title_class                  = $this->input->post->get('title_class', '', 'string');
		$questionParams->description_class            = $this->input->post->get('description_class', '', 'string');
		$questionParams->custom_answer_placeholder    = $this->input->post->get('custom_answer_placeholder', '', 'string');
		$questionParams->regex                        = $this->input->post->get('regex', '', 'string');
		$questionParams->regex_msg                    = $this->input->post->get('regex_msg', '', 'string');
		$questionParams->num_rating_stars             = $this->input->post->get('num_rating_stars', 5, 'uint');
		$questionParams->randomize_answers            = $this->input->post->get('randomize_answers', 0, 'int');
		$questionParams->slider_min_value             = $this->input->post->get('slider_min_value', 0, 'int');
		$questionParams->slider_max_value             = $this->input->post->get('slider_max_value', 100, 'int');
		$questionParams->slider_step_size             = $this->input->post->get('slider_step_size', 1, 'int');
		$questionParams->rating_hints                 = $this->input->post->get('rating_hints', '', 'string');
		$questionParams->allowed_file_types           = $this->input->post->get('allowed_file_types', '', 'string');
		$questionParams->hide_title_field             = $this->input->post->get('hide_title_field', 0, 'int');
		$questionParams->min_date                     = $this->input->post->get('min_date', 0, 'string');
		$questionParams->max_date                     = $this->input->post->get('max_date', 0, 'string');
		
		$weights                                      = $this->input->post->getArray(array('rank_weight'=>'int'));
		
		if(!empty($weights['rank_weight']))
		{
			foreach ($weights['rank_weight'] as $i => $weight)
			{
				$attr = 'rank_weight_'.($i + 1);
				$questionParams->$attr = $weight;
			}
		}
		
		$question->params = json_encode($questionParams);
		
		if(($question->id && empty($question->title)) || !$question->survey_id || !$question->question_type || !$question->page_number)
		{
			throw new Exception(JText::_('COM_COMMUNITYSURVEYS_REQUIRED_FIELDS_MISSING') . '| RC=1', 403);
		}
		
		if(! $this->isUserAuthorised($question->survey_id))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=2', 403);
		}
		
		if(!$question->id)
		{
			// new question
			$question->title = $question->question_type == CS_CHOICE_NPS 
				? JText::_('COM_COMMUNITYSURVEYS_NPS_QUESTION')
				: JText::_('COM_COMMUNITYSURVEYS_QUESTION_TITLE');
		}
		else 
		{
			$question->_survey_id = $question->survey_id;
			$question->_page_number = $question->page_number;
			unset($question->sort_order);
			unset($question->survey_id);
			unset($question->page_number);
		}
		
		$model = $this->getModel();
		if (! $model->save($question))
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED').'| RC=2', 500);
		}
		
		$recordId = $model->getState($model->getName() . '.id');
		
		if(!$recordId)
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED').'| RC=3', 500);
		}
		
		$model = $this->getModel('questions');
		$model->setState('filter.question_id', $recordId);
		$questions = $model->getItems();
		
		if(!empty($questions))
		{
			$pages = $model->getPages($questions['0']->survey_id);
			$params = JComponentHelper::getParams('com_communitysurveys');
			
			if($app->isAdmin())
			{
				$params->set('ui_layout', CS_MAJOR_VERSION < 4 ? 'default' : 'bootstrap4');
			}
			$layout = $params->get('ui_layout', 'default');
			$params->set('load_editor', false);
			
			JLoader::import('joomla.application.component.model');
			JLoader::import('rules', JPATH_ADMINISTRATOR.'/components/com_communitysurveys//models');
			$rulesModel	= JModelLegacy::getInstance( 'rules', 'CommunitySurveysModel' );
			$rulesModel->getState();
			$rulesModel->setState('filter.survey_id', $questions['0']->survey_id);
			$rules = $rulesModel->getItems();
			
			if(!empty($rules))
			{
				foreach ($rules as $rule)
				{
					foreach ($questions as &$question)
					{
						if($question->id == $rule->question_id)
						{
							$question->rules[] = $rule;
							break;
						}
					}
				}
			}
				
			$html = SurveyHelper::renderLayout($layout.'.form.question', array('item'=>$questions['0'], 'pages'=>$pages, 'params'=>$params));
			echo new JResponseJson($html);
		}
		else 
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED').'| RC=4', 500);
		}
		
		jexit();
	}
	
	protected function addPage()
	{
		$app 		= JFactory::getApplication();
		$user 		= JFactory::getUser();
		
		$page 		= new stdClass();
		$page->id 	= $app->input->getInt('pid', 0);
		$surveyId 	= $app->input->getInt('survey_id', 0);
		
		if (! $surveyId || ! $user->authorise('core.create', 'com_communitysurveys.survey.' . $surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=1', 403);
		}
		
		if(! $this->isUserAuthorised($surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=2', 403);
		}
		
		$model = $this->getModel();
		$page->sid = $surveyId;
		if(!$page->id)
		{
			$page->sid = $surveyId;
		}
		
		if(! $model->savePage($page))
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED').'| RC=3', 500);
		}
		
		$return = new stdClass();
		$return->pid = $model->getState($model->getName() . '.id');;
		$return->html = '';
		$return->title = JText::sprintf('COM_COMMUNITYSURVEYS_PAGE_TITLE_LABEL', '', array('jsSafe'=>true)).' (ID: '.$page->id.')';
		
		echo new JResponseJson($return);
	}
	
	protected function deletePage()
	{
		$app 		= JFactory::getApplication();
		$user 		= JFactory::getUser();
		
		$pageId 	= $app->input->getInt('pid', 0);
		$surveyId 	= $app->input->getInt('survey_id', 0);
		
		if (! $surveyId || ! $user->authorise('core.create', 'com_communitysurveys.survey.' . $surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=1', 403);
		}
		
		if(! $this->isUserAuthorised($surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=2', 403);
		}
		
		$model = $this->getModel();
		if(! $model->deletePage($surveyId, $pageId))
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED').'| RC=3', 500);
		}
		
		$app->enqueueMessage(JText::_('COM_COMMUNITYSURVEYS_PAGE_SUCCESSFULLY_DELETED'));
		echo new JResponseJson('1');
	}

	protected function loadPage($surveyId = 0, $pageId = 0)
	{
		$app 	= JFactory::getApplication();
		$user 	= JFactory::getUser();
		$surveyId = $surveyId > 0 ? $surveyId : $app->input->getInt('survey_id', 0);
		$pid 	= $pageId > 0 ? $pageId : $app->input->getInt('pid', 0);
	
		if (! $surveyId || ! $user->authorise('core.create', 'com_communitysurveys.survey.' . $surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=1', 403);
		}
		
		if(! $this->isUserAuthorised($surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=2', 403);
		}
	
		$model = $this->getModel('questions');
		$model->setState('filter.survey_id', $surveyId);
		$model->setState('filter.category_id', 0);
		$model->setState('filter.page_id', $pid);
		$model->setState('filter.question_id', null);
		$model->setState('list.ordering', 'a.sort_order');
		$model->setState('list.direction', 'asc');
		$model->setState('list.limit', 0);
		$questions = $model->getItems();
		$html = '';

		if(!empty($questions))
		{
			$pages = $model->getPages($surveyId);
			$params = JComponentHelper::getParams('com_communitysurveys');

			if($app->isAdmin())
			{
			    $params->set('ui_layout', CS_MAJOR_VERSION < 4 ? 'default' : 'bootstrap4');
			}
			$layout = $params->get('ui_layout', 'default');
			
			foreach ($questions as $question)
			{
				$html .= SurveyHelper::renderLayout($layout.'.form.question', array('item'=>$question, 'pages'=>$pages, 'params'=>$params));
			}
		}
		
		$return = new stdClass();
		$return->pid = $pid;
		$return->html = $html;
		
		echo new JResponseJson($return);
	}
	
	protected function uploadImage()
	{
		$params = JComponentHelper::getParams('com_communitysurveys');
		$allowed_extensions = $params->get('allowed_image_types', 'jpg,png,gif');
		$allowed_size = ((int)$params->get('max_attachment_size', 256))*1024;
		$input = JFactory::getApplication()->input;
		
		if(!empty($allowed_extensions))
		{
			$tmp_file = $input->files->get('input-attachment');
			if($tmp_file['error'] > 0)
			{
				throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED') . '| RC=1', 500);
			} 
			else 
			{
				$temp_file_path = $tmp_file['tmp_name'];
				$temp_file_name = $tmp_file['name'];
				$temp_file_ext = JFile::getExt($temp_file_name);
		
				if (!in_array(strtolower($temp_file_ext), explode(',', strtolower($allowed_extensions))))
				{
					throw new Exception(JText::_('COM_COMMUNITYSURVEYS_ERROR_INVALID_FILE_TYPE') . '| RC=2', 403);
				} 
				else if ($tmp_file['size'] > $allowed_size)
				{
					throw new Exception(JText::_('COM_COMMUNITYSURVEYS_ERROR_MAX_SIZE_FAILURE') . '| RC=3', 403);
				} 
				else 
				{
					$file_name = CjLibUtils::getRandomKey(25, 'abcdefghijklmnopqrstuvwxyz1234567890').'.'.$temp_file_ext;
					if(JFile::upload($temp_file_path, CS_TEMP_STORE.'/'.$file_name))
					{
						echo new JResponseJson(array('filename'=>$file_name, 'url'=>CS_TEMP_STORE_URI.$file_name));
					} 
					else 
					{
						throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED') . '| RC=4', 500);
					}
				}
			}
		
		} 
		else 
		{
			echo new JResponseJson(array('filename'=>'', 'url'=>''));
		}
		jexit();
	}
	
	protected function remove()
	{
		$app 	= JFactory::getApplication();
		$user 	= JFactory::getUser();
		$surveyId = $app->input->getInt('survey_id', 0);
		$questionId = $app->input->getInt('id', 0);
	
		if (! $surveyId || !$questionId || ! $user->authorise('core.create', 'com_communitysurveys.survey.' . $surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=1', 403);
		}
		
		if(! $this->isUserAuthorised($surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=2', 403);
		}
	
		$model = $this->getModel();
		if(!$model->deleteQuestion($surveyId, $questionId))
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED') . '| RC=3', 500);
		}
		
		echo new JResponseJson(1);
	}
	
	protected function move()
	{
		$app 		= JFactory::getApplication();
		$user 		= JFactory::getUser();
		$surveyId 	= $app->input->get('survey_id', 0, 'uint');
		$questionId = $app->input->get('id', 0, 'uint');
		$pageId		= $app->input->get('pid', 0, 'uint');
		$newPageId	= $app->input->get('newpid', 0, 'uint');

		if (! $surveyId || !$questionId || ! $user->authorise('core.create', 'com_communitysurveys.survey.' . $surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=1', 403);
		}
		
		if($pageId == $newPageId)
		{
			throw new Exception(JText::_('COM_COMMUNITYSURVEYS_TARGET_PAGE_SAME_AS_CURRENT') . '| RC=1', 403);
		}
		
		if(! $this->isUserAuthorised($surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=2', 403);
		}
	
		$model = $this->getModel();
		if(!$model->move($surveyId, $questionId, $newPageId))
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED') . '| RC=3', 500);
		}
		
		echo new JResponseJson(1);
	}

	protected function copy()
	{
		$app 		= JFactory::getApplication();
		$user 		= JFactory::getUser();
		$surveyId 	= $app->input->get('survey_id', 0, 'uint');
		$questionId = $app->input->get('id', 0, 'uint');
		$pageId		= $app->input->get('pid', 0, 'uint');
		$newPageId	= $app->input->get('newpid', 0, 'uint');
	
		if (! $surveyId || !$questionId || ! $user->authorise('core.create', 'com_communitysurveys.survey.' . $surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=1', 403);
		}
	
// 		if($pageId == $newPageId)
// 		{
// 			throw new Exception(JText::_('COM_COMMUNITYSURVEYS_TARGET_PAGE_SAME_AS_CURRENT') . '| RC=1', 403);
// 		}
	
		if(! $this->isUserAuthorised($surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=2', 403);
		}
	
		$model = $this->getModel();
		if(!$model->copy($surveyId, $questionId, $newPageId))
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED') . '| RC=3', 500);
		}
	
		echo new JResponseJson(1);
	}
	
	protected function savePageTitle()
	{
		$app 		= JFactory::getApplication();
		$user 		= JFactory::getUser();
		$surveyId 	= $app->input->get('survey_id', 0, 'uint');
		$pageId		= $app->input->get('pid', 0, 'uint');
		$newTitle	= $app->input->get('data', 0, 'string');
	
		if (! $surveyId || ! $user->authorise('core.create', 'com_communitysurveys.survey.' . $surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=1', 403);
		}
	
		if(! $this->isUserAuthorised($surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=2', 403);
		}
	
		$model = $this->getModel();
		if(!$model->savePageTitle($surveyId, $pageId, $newTitle))
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED') . '| RC=3', 500);
		}
	
		echo new JResponseJson(JText::sprintf('COM_COMMUNITYSURVEYS_PAGE_TITLE_LABEL', $newTitle, array('jsSafe'=>true)).' (ID: '.$pageId.')');
	}
	
	protected function reorder()
	{
		$app 		= JFactory::getApplication();
		$user 		= JFactory::getUser();
		$surveyId 	= $app->input->get('survey_id', 0, 'uint');
		$pageId		= $app->input->get('pid', 0, 'uint');
		$orders		= $app->input->get('data', 0, 'string');
		
		if (! $surveyId || !$pageId || empty($orders) || ! $user->authorise('core.create', 'com_communitysurveys.survey.' . $surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=1', 403);
		}
	
		if(! $this->isUserAuthorised($surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=2', 403);
		}
	
		$model = $this->getModel();
		if(!$model->saveSortOrder($surveyId, $pageId, $orders))
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED') . '| RC=3', 500);
		}
		
		echo new JResponseJson(1);
	}
	
	protected function reorderPages()
	{
		$app 		= JFactory::getApplication();
		$user 		= JFactory::getUser();
		$surveyId 	= $app->input->get('survey_id', 0, 'uint');
		$orders		= $app->input->get('data', array(), 'array');
		
		if (! $surveyId || empty($orders) || ! $user->authorise('core.create', 'com_communitysurveys.survey.' . $surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=1', 403);
		}
		
		if(! $this->isUserAuthorised($surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=2', 403);
		}
		
		$model = $this->getModel();
		if(!$model->savePageSortOrder($surveyId, $orders))
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED') . '| RC=3', 500);
		}
		
		echo new JResponseJson(1);
	}
	
	protected function isUserAuthorised($surveyId)
	{
		$user = JFactory::getUser();
		if($user->guest)
		{
			throw new Exception(JText::_('JGLOBAL_YOU_MUST_LOGIN_FIRST'), 403);
		}
		
		// if user is not authorised to for global edit permission, check if user owned this survey
		if($user->authorise('core.edit', 'com_communitysurveys.survey.' . $surveyId))
		{
			return true;
		}

		$model = $this->getModel('survey');
		$survey = $model->getItem($surveyId);
	
		if(!empty($survey) && $survey->created_by == $user->id)
		{
			return true;
		}
		
		return false;
	}
	
	protected function saveRule()
	{
	    $app			= JFactory::getApplication();
	    $user			= JFactory::getUser();
	    $surveyId		= $app->input->get('survey_id', 0, 'uint');
	    $questionId		= $app->input->get('qid', 0, 'uint');
	    $ruleNames		= array(1=>'answered', 2=>'unanswered', 3=>'selected', 4=>'unselected');
	    
	    if (! $surveyId || !$questionId || ! $user->authorise('core.create', 'com_communitysurveys.survey.' . $surveyId))
	    {
	        throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=1', 403);
	    }
	    
	    if(! $this->isUserAuthorised($surveyId))
	    {
	        throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=2', 403);
	    }
	    
	    $ruleContent				= new stdClass();
	    $outcome					= $app->input->get('rule-outcome', 0, 'uint');
	    $ruleType					= $app->input->get('rule-name', 0, 'uint');
	    
	    $ruleContent->name			= isset($ruleNames[$ruleType]) ? $ruleNames[$ruleType] : null;
	    $ruleContent->answer_id		= $app->input->get('rule-answer', 0, 'uint');
	    $ruleContent->column_id		= $app->input->get('rule-column', 0, 'uint');
	    $ruleContent->page			= $outcome == 1 ? $app->input->get('rule-page', 0, 'uint') : 0;
	    $ruleContent->finalize		= $outcome == 2 ? 1 : 0;
	    $ruleContent->question		= ($outcome == 3 && in_array($ruleContent->name, array('selected', 'answered'))) ? $app->input->get('rule-show-question', 0, 'uint') : 0;
	    
	    if(!$ruleContent->column_id)
	    {
	    	$ruleContent->column_id = $app->input->get('rule-rating', 0, 'uint');
	    }

	    if(
	            !$ruleContent->name || 
	            ($ruleContent->page == 0 && $ruleContent->finalize == 0 && $ruleContent->question == 0) || 
	            ($ruleContent->answer_id <= 0 && in_array($ruleContent->name, array('selected', 'unselected')))
        )
	    {
	        throw new Exception(JText::_('COM_COMMUNITYSURVEYS_REQUIRED_FIELDS_MISSING') . '| RC=3', 403);
	    }

	    $model                     = $this->getModel();
	    $rule                      = new stdClass();
	    $rule->survey_id           = $surveyId;
	    $rule->question_id         = $questionId;
	    $rule->rulecontent         = json_encode($ruleContent);
	    
	    if(!$model->saveConditionalRule($rule))
	    {
	        throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED') . '| RC=4', 500);
	    }
	    
	    JLoader::import('joomla.application.component.model');
	    JLoader::import('rules', JPATH_ADMINISTRATOR.'/components/com_communitysurveys/models');
	    
	    $rulesModel = $this->getModel('rules');
	    $rulesModel->getState();
	    $rulesModel->setState('filter.survey_id', $surveyId);
	    $rulesModel->setState('filter.question_id', $questionId);
	    
	    $rules = $rulesModel->getItems();
	    
	    echo new JResponseJson($rules);
	}
	
	protected function deleteRule()
	{
		$app			= JFactory::getApplication();
		$user			= JFactory::getUser();
		$ruleId			= $app->input->get('rule_id', 0, 'uint');
		$surveyId		= $app->input->get('survey_id', 0, 'uint');
		$questionId		= $app->input->get('qid', 0, 'uint');
		 
		if (!$ruleId || ! $surveyId || !$questionId || ! $user->authorise('core.create', 'com_communitysurveys.survey.' . $surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=1', 403);
		}
		 
		if(! $this->isUserAuthorised($surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=2', 403);
		}
		
		$model = $this->getModel();
		if(!$model->deleteConditionalRule($ruleId, $surveyId, $questionId))
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED') . '| RC=3', 500);
		}
		
		echo new JResponseJson(1);
	}
}