<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class CommunitySurveysControllerReportsBase extends JControllerAdmin
{
	protected $text_prefix = 'COM_COMMUNITYSURVEYS';
	protected $base_path = CS_LAYOUTS_BASE_PATH;
	
	public function __construct ($config = array())
	{
		parent::__construct($config);
	}
	
	public function execute ($task)
	{
		try
		{
			switch ($task)
			{
				case 'getanswers':
					$this->getTextAnswers();
					break;
					
				case 'comment':
				    $this->saveComment();
				    break;
			}
		}
		catch (Exception $e)
		{
			echo new JResponseJson($e);
		}
	
		jexit();
	}
	
	protected function getTextAnswers()
	{
	    $app = JFactory::getApplication();
	    $model = $this->getModel();
	    $user = JFactory::getUser();
	    
	    $surveyId = $app->input->getInt('id');
	    $questionId = $app->input->getInt('qid');
	    
	    if(!$user->authorise('core.results', 'com_communitysurveys'))
	    {
	        throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'));
	    }
	    
	    $textAnswers = $model->getTextAnswers($surveyId, $questionId);
	    $params = JComponentHelper::getParams('com_communitysurveys');
	    if($app->isAdmin())
	    {
	    	$params->set('ui_layout', 'default');
	    }
	    
	    $layout = $params->get('ui_layout', 'default');
	    $output = SurveyHelper::renderLayout($layout.'.reports.textanswers', array('answers'=>$textAnswers, 'params'=>$params));
	    echo new JResponseJson($output);
	}
}