<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

use Joomla\Utilities\ArrayHelper;

class CommunitySurveysControllerSurvey extends JControllerForm
{
	protected $view_item = 'survey';
	protected $view_list = 'surveys';
	
	public function __construct($config = array())
	{
		parent::__construct($config);
	}

	protected function allowAdd($data = array())
	{
		$user = JFactory::getUser();
		$categoryId = ArrayHelper::getValue($data, 'catid', $this->input->getInt('filter_category_id'), 'int');
		$allow = null;

		if ($categoryId)
		{
			// If the category has been passed in the data or URL check it.
			$allow = $user->authorise('core.create', 'com_communitysurveys.category.' . $categoryId);
		}

		if ($allow === null)
		{
			// In the absense of better information, revert to the component permissions.
			return parent::allowAdd();
		}
		else
		{
			return $allow;
		}
	}

	/**
	 * Method override to check if you can edit an existing record.
	 *
	 * @param   array   $data  An array of input data.
	 * @param   string  $key   The name of the key for the primary key.
	 *
	 * @return  boolean
	 */
	protected function allowEdit($data = array(), $key = 'id')
	{
		$recordId = (int) isset($data[$key]) ? $data[$key] : 0;
		$user = JFactory::getUser();
		$userId = $user->get('id');

		// Check general edit permission first.
		if ($user->authorise('core.edit', 'com_communitysurveys.survey.' . $recordId))
		{
			return true;
		}

		// Fallback on edit.own.
		// First test if the permission is available.
		if ($user->authorise('core.edit.own', 'com_communitysurveys.survey.' . $recordId))
		{
			// Now test the owner is the user.
			$ownerId = (int) isset($data['created_by']) ? $data['created_by'] : 0;
			if (empty($ownerId) && $recordId)
			{
				// Need to do a lookup from the model.
				$record = $this->getModel()->getItem($recordId);

				if (empty($record))
				{
					return false;
				}

				$ownerId = $record->created_by;
			}

			// If the owner matches 'me' then do the test.
			if ($ownerId == $userId)
			{
				return true;
			}
		}

		// Since there is no asset tracking, revert to the component permissions.
		return parent::allowEdit($data, $key);
	}
	

	/**
	 * Method to run batch operations.
	 *
	 * @param   object  $model  The model.
	 *
	 * @return  boolean   True if successful, false otherwise and internal error is set.
	 */
	public function batch($model = null)
	{
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		// Set the model
		$model = $this->getModel('Survey', '', array());

		// Preset the redirect
		$this->setRedirect(JRoute::_('index.php?option=com_communitysurveys&view=surveys' . $this->getRedirectToListAppend(), false));

		return parent::batch($model);
	}

	/**
	 * Function that allows child controller access to model data after the data has been saved.
	 *
	 * @param   JModelLegacy  $model  The data model object.
	 * @param   array         $validData   The validated data.
	 *
	 * @return	void
	 */
	protected function postSaveHook(JModelLegacy $model, $validData = array())
	{
		return;
	}
	
	public function publish()
	{
	    $user = JFactory::getUser();
	    $model = $this->getModel('Survey', '', array());
	    $id = $this->input->getInt('id');
	    
	    if(!$id || (!$user->authorise('core.create', 'com_communitysurveys') && !$user->authorise('core.manage', 'com_communitysurveys')))
	    {
	        throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'));
	    }
	    
	    if($model->makeSurveyOnline($id))
	    {
	        $this->setRedirect(JRoute::_('index.php?option=com_communitysurveys&view=surveys', false), JText::_('COM_COMMUNITYSURVEYS_SURVEY_SUCCESSFULLY_PUBLISHED'));
	    }
	    else
	    {
	        $this->setRedirect(JRoute::_('index.php?option=com_communitysurveys&view=surveys', false), JText::_('COM_COMMUNITYSURVEYS_ERROR_INTERNAL_ERROR'), 'error');
	    }
	}
	
	public function cancel()
	{
	    $key = $this->input->getInt('id');
	    parent::cancel();
	    
	    $this->setRedirect(JRoute::_('index.php?option=com_communitysurveys&view=reports&id='.$key, false));
	}
}
