<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class CommunitySurveysControllerTranslation extends JControllerForm
{
	public function __construct($config = array())
	{
		parent::__construct($config);
	}
	
	public function execute($task)
	{
	    try
	    {
	        switch ($task)
	        {
	            case 'save':
	                $this->save();
	                break;
	        }
	    }
	    catch (Exception $e)
	    {
	        echo new JResponseJson($e);
	    }
	    
	    jexit();
	}
	
	public function save($key = NULL, $urlVar = NULL) 
	{
	    $id = $this->input->getString('id');
	    $translation = JComponentHelper::filterText($this->input->post->get('translation', '', 'raw'));
	    
	    if(empty($id) || empty($translation)) 
	    {
	        throw new Exception(JText::_('COM_COMMUNITYSURVEYS_REQUIRED_FIELDS_MISSING'), 404);
	    }
	    
	    $model = $this->getModel('Translation');
	    if(!$model->saveTranslation($id, $translation))
	    {
	        throw new Exception(JText::_('COM_COMMUNITYSURVEYS_ERROR_INTERNAL_ERROR'), 500);
	    }

	    echo new JResponseJson($translation);
	}
}
