<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

class CommunitySurveysHelper
{
	public static $extension = 'com_communitysurveys';
	
	public static function addSubmenu($view){
		
		$option = JApplicationHelper::getComponentName();

		JHtmlSidebar::addEntry(JText::_('COM_COMMUNITYSURVEYS_DASHBOARD'), 'index.php?option=com_communitysurveys&amp;view=dashboard', $view == 'dashboard');
		JHtmlSidebar::addEntry(JText::_('COM_COMMUNITYSURVEYS_SURVEYS'), 'index.php?option=com_communitysurveys&amp;view=surveys', $view == 'surveys');
		JHtmlSidebar::addEntry(JText::_('COM_COMMUNITYSURVEYS_MENU_RESPONSES'), 'index.php?option=com_communitysurveys&amp;view=responses', $view == 'responses');
		JHtmlSidebar::addEntry(JText::_('COM_COMMUNITYSURVEYS_CATEGORIES'), 'index.php?option=com_categories&view=categories&extension=com_communitysurveys', ($view == 'categories' && $option != 'com_communitysurveys'));
		JHtmlSidebar::addEntry(JText::_('COM_COMMUNITYSURVEYS_MENU_EMAIL_TEMPLATES'), 'index.php?option=com_communitysurveys&amp;view=emails', $view == 'emails');
		
		if(JFactory::getUser()->authorise('core.admin', 'com_communitysurveys'))
		{
			JHtmlSidebar::addEntry(JText::_('COM_COMMUNITYSURVEYS_MENU_MIGRATE'), 'index.php?option=com_communitysurveys&amp;view=migrate', $view == 'migrate');
		}
	}
	
	public static function getActions($categoryId = 0, $surveyId = 0)
	{
		// Reverted a change for version 2.5.6
		$user	= JFactory::getUser();
		$result	= new JObject;
		
		if (empty($surveyId) && empty($categoryId)) {
			$assetName = 'com_communitysurveys';
		}
		elseif (empty($surveyId)) {
			$assetName = 'com_communitysurveys.category.'.(int) $categoryId;
		}
		else {
			$assetName = 'com_communitysurveys.survey.'.(int) $surveyId;
		}
		
		$actions = array(
				'core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.own', 'core.edit.state', 
				'core.edit.state.owm', 'core.delete', 'core.delete.own', 'core.approve', 'core.results', 'core.rate'
		);
		
		foreach ($actions as $action) {
			$result->set($action, $user->authorise($action, $assetName));
		}
		
		return $result;
	}
	
	public static function countItems(&$items)
	{
		$db = JFactory::getDbo();

		foreach ($items as $item)
		{
			$item->count_trashed = 0;
			$item->count_archived = 0;
			$item->count_unpublished = 0;
			$item->count_published = 0;
			$query = $db->getQuery(true);
			$query->select('published as state, count(*) AS count')
				->from($db->qn('#__survey_surveys'))
				->where('catid = ' . (int) $item->id)
				->group('published');
			$db->setQuery($query);
			$topics = $db->loadObjectList();

			foreach ($topics as $topic)
			{
				if ($topic->state == 1)
				{
					$item->count_published = $topic->count;
				}

				if ($topic->state == 0)
				{
					$item->count_unpublished = $topic->count;
				}

				if ($topic->state == 2)
				{
					$item->count_archived = $topic->count;
				}

				if ($topic->state == -2)
				{
					$item->count_trashed = $topic->count;
				}
			}
		}

		return $items;
	}
	
	public static function getTranslationTypeTitle($itemType)
	{
	    switch($itemType)
	    {
	        case CS_TRANSLATION_SURVEY_TITLE: 
	            return JText::_('COM_COMMUNITYSURVEYS_TRANSLATION_TYPE_SURVEY_TITLE');

	        case CS_TRANSLATION_SURVEY_DESC: 
	            return JText::_('COM_COMMUNITYSURVEYS_TRANSLATION_TYPE_SURVEY_DESCRIPTION');

	        case CS_TRANSLATION_SURVEY_ENDTEXT: 
	            return JText::_('COM_COMMUNITYSURVEYS_TRANSLATION_TYPE_END_TEXT');

	        case CS_TRANSLATION_SURVEY_HEADER: 
	            return JText::_('COM_COMMUNITYSURVEYS_TRANSLATION_TYPE_CUSTOM_HEADER');

	        case CS_TRANSLATION_PAGE_TITLE: 
	            return JText::_('COM_COMMUNITYSURVEYS_TRANSLATION_TYPE_PAGE_TITLE');

	        case CS_TRANSLATION_QUESTION_TITLE: 
	            return JText::_('COM_COMMUNITYSURVEYS_TRANSLATION_TYPE_QUESTION_TITLE');

	        case CS_TRANSLATION_QUESTION_DESC: 
	            return JText::_('COM_COMMUNITYSURVEYS_TRANSLATION_TYPE_QUESTION_DESCRIPTION');

	        case CS_TRANSLATION_ANSWER_TITLE: 
	            return JText::_('COM_COMMUNITYSURVEYS_TRANSLATION_TYPE_ANSWER');
	    }
	}
}
