<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

JFormHelper::loadFieldClass('list');

class JFormFieldBadge extends JFormFieldList
{
	protected $type = 'Badge';
	
	protected function getOptions()
	{
		$options = array();
		$db = JFactory::getDbo();
		
		try
		{
    		$query = $db->getQuery(true)
    			->select('a.id AS value, a.title AS text')
    			->from('#__cjblog_badge_rules AS a')
    			->where('a.rule_name = '.$db->q('com_communitysurveys.custom').' and a.published = 1')
    			->order('a.title ASC');
    		
    		$db->setQuery($query);
		    $options = $db->loadObjectList();
		}
		catch (Exception $e)
		{
		    // No CjBlog installed?
		    //throw new Exception($e->getMessage(), 500);
		}
		
		$options = array_merge(parent::getOptions(), $options);
		return $options;
	}
}