<?php
/**
 * @package     Joomla.Libraries
 * @subpackage  Form
 *
 * @copyright   Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

defined('JPATH_PLATFORM') or die;

JFormHelper::loadFieldClass('list');

class JFormFieldBrowser extends JFormFieldList
{
	public $type = 'browser';
	
	protected function getOptions()
	{
		$db = JFactory::getDbo();
		$app = JFactory::getApplication();
		
		$id = $app->input->getInt('id');
		
		$query = $db->getQuery(true)
			->select('browser_name as value, browser_name as text')
			->from('#__survey_tracking')
			->group('browser_name')
			->order('browser_name');
		
		if($id)
		{
			$query->where('post_id IN (select id from #__survey_responses where survey_id = '.$id.') and post_type = 1');
		}
			
		$db->setQuery($query);
		$options = $db->loadObjectList();
		$options = array_merge(parent::getOptions(), $options);
		
		return $options;
	}
}
