<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

class CommunitySurveysModelMailbase extends JModelLegacy 
{
	function __construct() 
	{
		parent::__construct ();
	}
	
	public function enqueueMail($message, $recipients, $template = 'none')
	{
		$app = JFactory::getApplication();
		$db = JFactory::getDbo();
		$site_name = $app->get('sitename');
		$site_url = JUri::root();
		
		try 
		{
			if(isset($message->params))
			{
				$message->params = array_merge($message->params, array('template'=>$template, 'placeholders'=>array()));
			}
			else 
			{
				$message->params = array('template'=>$template, 'placeholders'=>array());
			}
			
			$message->params = json_encode($message->params);
			$message->created = JFactory::getDate()->toSql();
			
			if(!$db->insertObject('#__corejoomla_messages', $message))
			{
				return false;
			}
			
			$messageId = $db->insertid();
			if($messageId > 0)
			{
				$query = $db->getQuery(true)
					->insert('#__corejoomla_messagequeue')
					->columns('message_id, to_addr, params, created, html');
					
				$uniqueMails = array(); // to filter out duplicate emails
				foreach ($recipients as $user)
				{
					if(in_array($user->email, $uniqueMails))
					{
						// email already scheduled, no need to add again.
						continue;
					}
					
					$uniqueMails[] = $user->email;
					$placeholders = array('{NAME}'=>$user->name);
					if(!empty($user->url))
					{
						$placeholders['{SURVEY_URL}'] = $user->url;
					}
					$userparams = json_encode(array('placeholders'=>$placeholders));
					$query->values($messageId.','.$db->q($user->email).','.$db->q($userparams).','.$db->q($message->created).', 1');
				}
				
				$db->setQuery($query);
				if(!$db->execute())
				{
					return false;
				}
			}
			
			$params = JComponentHelper::getParams('com_communitysurveys');
			if($params->get('skip_email_queue', 1))
			{
				CJFunctions::send_messages_from_queue(60, 0, false);
			}
			return true;
		}
		catch (Exception $e)
		{
			return false;
		}
		
		return false;
	}
}