<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

require_once CJLIB_PATH . '/lib/jbbcode/Parser.php';
require_once CJLIB_PATH . '/lib/jbbcode/custom/CjCustomCodeDefinitions.php';

class CommunitySurveysModelMigrate extends JModelLegacy
{

	protected $_error = '';

	function __construct ()
	{
		parent::__construct();
	}

	public function getFirstAndLastQuestionId ()
	{
		try
		{
			$db = JFactory::getDbo();
			$query = $db->getQuery(true)
				->select('min(id) AS min_id, max(id) AS max_id')
				->from('#__survey');
			
			$db->setQuery($query);
			$result = $db->loadObject();
			
			return $result;
		}
		catch (Exception $e)
		{
		}
	}

	public function migrateSurveys ($startId, $endId)
	{
		$db = JFactory::getDbo();
		$app = JFactory::getApplication();
		
		try
		{
			// now update descriptions if bbcode was used.
			$parseBBCode = $app->input->getInt('convert_bbcode', false);
			if($parseBBCode)
			{
			    $parser = new JBBCode\Parser();
			    $parser->addCodeDefinitionSet(new JBBCode\DefaultCodeDefinitionSet());
			    $parser->addCodeDefinitionSet(new JBBCode\CjCodeDefinitionSet());
			}
			
			$query = $db->getQuery(true)->select('*')->from('#__survey')->where('id >= ' . $startId . ' and id <= ' . $endId);
			$db->setQuery($query);
			$surveys = $db->loadAssocList();
			
			if ($surveys)
			{
				JLoader::import('survey', JPATH_ADMINISTRATOR.'/components/com_communitysurveys/models');
				$model = JModelLegacy::getInstance( 'MigrateSurvey', 'CommunitySurveysModel' );
				
				foreach ($surveys as $survey)
				{
					if($parseBBCode)
					{
						$survey['description'] = $parser->parse(nl2br(htmlspecialchars($survey['description'], ENT_COMPAT, 'UTF-8')))->getAsHtml();
						$survey['endtext'] = $parser->parse(nl2br(htmlspecialchars($survey['endtext'], ENT_COMPAT, 'UTF-8')))->getAsHtml();
						$survey['custom_header'] = $parser->parse(nl2br(htmlspecialchars($survey['custom_header'], ENT_COMPAT, 'UTF-8')))->getAsHtml();
					}
					
					$new = array();
					$new['id'] = $survey['id'];
					$new['catid'] = $survey['catid'];
					$new['title'] = $survey['title'];
					$new['description'] = $survey['introtext'];
					$new['endtext'] = $survey['endtext'];
					$new['custom_header'] = $survey['custom_header'];
					$new['survey_key'] = $survey['survey_key'];
					$new['published'] = $survey['published'];
					$new['created_by'] = $survey['created_by'];
					$new['created'] = $survey['created'];
					$new['private'] = $survey['private_survey'];
					$new['max_responses'] = $survey['max_responses'];
					$new['redirect_url'] = $survey['redirect_url'];
					$new['restrictions'] = explode(',', $survey['restriction']);
					$new['ordering'] = 0;//$survey['ordering'];
					$new['responses'] = $survey['responses'];
					$new['ip_address'] = $survey['ip_address'];
					$new['access'] = 1;//$survey['access'];
					$new['language'] = $survey['language'];
					$new['publish_up'] = $survey['publish_up'];
					$new['publish_down'] = $survey['publish_down'];
					$new['language'] = $survey['language'];
					
					$attributes = new stdClass();
					$attributes->show_intro = $survey['skip_intro'] ? 0 : 1;
					$attributes->show_template = $survey['display_template'];
					$attributes->show_report = $survey['public_permissions'];
					$attributes->show_notice = $survey['display_notice'];
					$attributes->show_pagination = $survey['display_progress'];
					$attributes->show_save_button = $survey['enable_save_btn'];
					$attributes->show_prev_button = $survey['backward_navigation'];
					$attributes->send_notifications = $survey['notification'];
					$attributes->is_anonymous = $survey['anonymous'];
					
					$new['attribs'] = json_encode($attributes);
					
					if(!$model->save($new))
					{
						$app->enqueueMessage($model->getError());
					}
				}
			}
			
			if($parseBBCode)
			{
				$query = $db->getQuery(true)->select('id, description')->from('#__survey_questions')->where('survey_id >= ' . $startId . ' and survey_id <= ' . $endId);
				$db->setQuery($query);
				$questions = $db->loadObjectList();
				
				if ($questions)
				{
					$subQueries = array();
					$query = $db->getQuery(true)->update('#__survey_questions');
					
					foreach ($questions as $question)
					{
						$description = $parser->parse(nl2br(htmlspecialchars($question->description, ENT_COMPAT, 'UTF-8')))->getAsHtml();
						$subQueries[] = 'when ' . $question->id . ' then ' . $db->q($description);
					}
					
					$query->set('description = (case id ' . implode(' ', $subQueries) . ' end)');
					$query->where('survey_id >= ' . $startId . ' and survey_id <= ' . $endId);
					$db->setQuery($query);
					$db->execute();
				}
			}
			
			// now upgrade tracking statistics
			$query = $db->getQuery(true)
				->select('id, ip_address, country, city, os, browser')
				->from('#__survey_responses')
				->where('survey_id >= ' . $startId . ' and survey_id <= ' . $endId);
			
			$db->setQuery($query);
			$responses = $db->loadObjectList();
			
			if(!empty($responses))
			{
				$numItems = 100;
				$numSteps = ceil(count($responses) / $numItems);
				$query = $db->getQuery(true)
					->insert('#__survey_tracking')
					->columns('post_id, post_type, ip_address, country, city, browser_name, browser_version, os, browser_info');
				
				for ($i = 0; $i < $numSteps; $i++)
				{
					$values = array();
					$start = $i * $numItems;
					$end = $start + $numItems;
					$query->clear('values');
					
					if(count($responses) < $end)
					{
						$end = count($responses);
					}
					
					for ($j = $start; $j < $end; $j++)
					{
						$res = $responses[$j];
						$browser_name = $browser_version = '';
						
						if(empty($res->os) && empty($res->city) && empty($res->browser))
						{
							continue;
						}
						
						if(!empty($res->os) && !empty($res->city))
						{
							$browser_name = implode(' ', explode(' ', $res->browser, -1));
							$parts = explode(' ', $res->browser);
							
							if(count($parts) > 1)
							{
								$browser_version = array_pop($parts);
							}
						}
						else if(!empty($res->browser))
						{
							$location = @CJFunctions::get_browser($res->browser);
							$browser_name = $location['name'];
							$browser_version = $location['version'];
							$res->os = $location['platform'];
						}
						
						$query->values(
								$res->id.', 1, '.
								$db->q($res->ip_address).','.
								$db->q($res->country).','.
								$db->q($res->city).','.
								$db->q($browser_name).','.
								$db->q($browser_version).','.
								$db->q($res->os).','.
								$db->q($res->browser));
					}
					
					$db->setQuery($query);
					try
					{
						$db->execute();
					}
					catch (Exception $e)
					{
// 									echo $e->getMessage();
// 									return false;
						// ignore errors and continue to next
					}
				}
			}
		}
		catch (Exception $e)
		{
			echo $e->getMessage();
			return false;
		}
		
		return true;
	}

	public function doFinalSteps ()
	{
		$db = JFactory::getDbo();
		
		try
		{
			$query = 'insert into #__assets (parent_id, level, name, title, rules) ' .
					 'select c.asset_id as parent_asset_id, c.level + 1 as level, concat(\'com_communitysurveys.survey.\', p.id) as name, p.title,' .
					 '\'{"core.create":[],"core.edit":[],"core.edit.own":[],"core.edit.state":[],"core.edit.state.own":[],' .
					 '"core.delete":[],"core.delete.own":[],"core.respond":[],"core.results":[]}\' ' . 
					 'from #__survey_surveys as p ' .
					 'inner join #__categories as c on p.catid = c.id ' . 'on duplicate key update id=values(id)';
			$db->setQuery($query);
			if ($db->execute())
			{
				$query = 'update #__survey_surveys q INNER JOIN #__assets a ON a.name = concat(\'com_communitysurveys.survey.\', q.id) set q.asset_id = a.id';
				$db->setQuery($query);
				
				if ($db->execute())
				{
					$this->shapeshift(1, 1, true);
				}
			}
		}
		catch (Exception $e)
		{
		    // 			echo $e->getMessage();
			// return false;
		}
		
		return true;
	}

	/**
	 * credit:
	 * http://www.sitepoint.com/forums/showthread.php?320444-Adjacency-list-table-to-Nested-Set-table-conversion-algorithm&s=0a186a3e9aa0b43c2c9f00bdad6575e5&p=4789281&viewfull=1#post4789281
	 */
	function shapeshift ($lft = 1, $father = 0, $isroot = false)
	{
		$db = JFactory::getDBO();
		$tbl_from = '#__assets';
		$tbl_to = '#__assets';
		
		$query = "select * from $tbl_from where id = $father";
		$db->setQuery($query);
		$cat = $db->loadObject();
		$rgt = $lft + 1;
		
		$query = "select * from $tbl_from where parent_id = $father";
		$db->setQuery($query);
		$sibs = $db->loadObjectList();
		
		foreach ($sibs as $sib)
		{
			$rgt = $this->shapeshift($rgt, $sib->id);
		}
		
		if ($cat->id)
		{
			$query = "update $tbl_to set lft = $lft,rgt = $rgt where id = $cat->id";
			$db->setQuery($query);
			$db->Query();
		}
		
		$rgt += 1;
		
		return $rgt;
	}

	private function batchTag ($value, $pks)
	{
		// Clean the cache
		$this->cleanCache();
		
		return true;
	}

	public function getTable ($type = 'Survey', $prefix = 'CommunitySurveysTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}
}