<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

class CommunitySurveysModelQuestionsBase extends JModelList
{
	public function __construct ($config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = array(
					'id', 'a.id',
					'survey_id', 'a.survey_id',
					'created_by', 'a.created_by',
					'sort_order', 'a.sort_order',
					'page_number', 'a.page_number'
			);
		}
		
		parent::__construct($config);
	}

	protected function populateState ($ordering = 'sort_order', $direction = 'ASC')
	{
		$app = JFactory::getApplication();
		$params = JComponentHelper::getParams('com_communitysurveys');
		
		// List state information
		$value = $app->input->get('limit', $params->get('questions_limit', 1), 'uint');
		$this->setState('list.limit', $value);
		
		$value = $app->input->get('limitstart', 0, 'uint');
		$this->setState('list.start', $value);
		
		$categories = $app->input->getArray(array('catid'=>'array'));
		$this->setState('filter.category_id', $categories['catid']);
		
		$questions = $app->input->getArray(array('qid'=>'array'));
		$this->setState('filter.question_id', $questions['qid']);
		
		$surveyId = $app->input->get('survey_id', 0, 'uint');
		if($surveyId)
		{
			$this->setState('filter.survey_id', $surveyId);
		}
		
		$pageId = $app->input->get('page_id', 0, 'uint');
		if($pageId)
		{
			$this->setState('filter.page_id', $pageId);
		}
		
		// Filtering for unique questions for category survey
		$filterUniq = $app->input->get('filter_unique', false, 'boolean');
		$this->setState('filter.unique', $filterUniq);
		
		$filterResponseId = $app->input->get('filter_response_id', 0, 'uint');
		$this->setState('filter.response_id', $filterResponseId);
		
		$orderCol = $app->input->get('filter_order', $params->get('questions_ordering', 'a.sort_order'));
		
		if (! in_array($orderCol, $this->filter_fields))
		{
			$orderCol = 'a.sort_order';
		}
		
		$this->setState('list.ordering', $orderCol);
		
		$listOrder = $app->input->get('filter_order_Dir', $params->get('questions_ordering_dir', 'DESC'));
		
		if (! in_array(strtoupper($listOrder), array('ASC', 'DESC', '')))
		{
			$listOrder = 'DESC';
		}
		
		$this->setState('list.direction', $listOrder);
		$this->setState('params', $params);
	}

	protected function getStoreId ($id = '')
	{
		// Compile the store id.
		$id .= ':' . $this->getState('filter.survey_id');
		$id .= ':' . $this->getState('filter.survey_id.include');
		$id .= ':' . $this->getState('filter.page_id');
		$id .= ':' . $this->getState('filter.page_id.include');
		$id .= ':' . $this->getState('filter.question_id.include');
		$id .= ':' . $this->getState('filter.category_id.include');
		
		return parent::getStoreId($id);
	}

	protected function getListQuery ()
	{
		// Create a new query object.
		$db = $this->getDbo();
		$query = $db->getQuery(true);
		
		// Select the required fields from the table.
		$query->select(
				$this->getState('list.select', 
						'a.id, a.title, a.description, a.survey_id, a.question_type, a.page_number, a.sort_order, p.sort_order AS page_order,'.
						'a.custom_choice, a.mandatory, a.orientation, 0 as total_votes, a.min_selections, a.max_selections, a.params'));
		
		$query
			->from('#__survey_questions AS a')
			->join('inner', '#__survey_pages p on p.id = a.page_number');
		
		// Filter by survey id.
		$surveyId = (int) $this->getState('filter.survey_id');
		if ($surveyId)
		{
			$query->where('a.survey_id = '.$surveyId);
		}
		
		// Filter by page id.
		$pageId = $this->getState('filter.page_id');
		if($pageId)
		{
			$query->where('a.page_number = '.$pageId);
		}

		// Filter by single or group of questions.
		$questionId = $this->getState('filter.question_id');
		if (is_numeric($questionId) && $questionId)
		{
			// join over surveys table
			$type = $this->getState('filter.question_id.include', true) ? '= ' : '<> ';
			$query->where('a.id ' . $type . (int) $questionId);
		}
		elseif (is_array($questionId) && (count($questionId) > 0))
		{
			$questionId = Joomla\Utilities\ArrayHelper::toInteger($questionId);
			$questionId = implode(',', $questionId);
		
			if (! empty($questionId))
			{
				$type = $this->getState('filter.question_id.include', true) ? 'IN' : 'NOT IN';
				$query->where('a.id ' . $type . ' (' . $questionId . ')');
			}
		}
		
		$categoryId = $this->getState('filter.category_id');
		if (is_numeric($categoryId) && $categoryId)
		{
			// join over surveys table
			$query->join('inner', '#__survey_surveys AS q on q.id = a.survey_id');
			
			$type = $this->getState('filter.category_id.include', true) ? '= ' : '<> ';
				
			// Add subcategory check
			$includeSubcategories = $this->getState('filter.subcategories', false);
			$categoryEquals = 'q.catid ' . $type . (int) $categoryId;

			if ($includeSubcategories)
			{
				$levels = (int) $this->getState('filter.max_category_levels', '1');
		
				// Create a subquery for the subcategory list
				$subQuery = $db->getQuery(true)
				->select('sub.id')
				->from('#__categories as sub')
				->join('INNER', '#__categories as this ON sub.lft > this.lft AND sub.rgt < this.rgt')
				->where('this.id = ' . (int) $categoryId);
		
				if ($levels >= 0)
				{
					$subQuery->where('sub.level <= this.level + ' . $levels);
				}
		
				// Add the subquery to the main query
				$query->where('(' . $categoryEquals . ' OR q.catid IN (' . $subQuery->__toString() . '))');
			}
			else
			{
				$query->where($categoryEquals);
			}
		}
		elseif (is_array($categoryId) && (count($categoryId) > 0))
		{
			$categoryId = Joomla\Utilities\ArrayHelper::toInteger($categoryId);
			$categoryId = implode(',', $categoryId);
				
			if (! empty($categoryId))
			{
				// join over surveys table
				$query->join('inner', '#__survey_surveys AS q on q.id = a.survey_id');
				
				$type = $this->getState('filter.category_id.include', true) ? 'IN' : 'NOT IN';
				$query->where('q.catid ' . $type . ' (' . $categoryId . ')');
			}
		}
		
		$filterUnique = (boolean) $this->getState('filter.unique');
		$responseId = (int) $this->getState('filter.response_id');
		
		if(!empty($categoryId) && $filterUnique && $responseId)
		{
			$query->where('a.id not in (select distinct question_id from #__survey_response_details where response_id = '.$responseId.')');
		}
		
		// Add the list ordering clause.
		$query->order('p.sort_order asc, a.sort_order asc');
// 		$query->order($this->getState('list.ordering', 'a.sort_order') . ' ' . $this->getState('list.direction', 'ASC'));
// echo $query->dump();
// jexit();
		return $query;
	}

	public function getStart ()
	{
		return $this->getState('list.start');
	}
	
	
	public function getPages($surveyId)
	{
	    $db = JFactory::getDbo();
	    
	    try
	    {
	        $query = $db->getQuery(true)
	        ->select('id, title, sort_order')
	        ->from('#__survey_pages')
	        ->where('sid = '.(int) $surveyId)
	        ->order('sort_order asc');
	        
	        $db->setQuery($query);
	        $pages = $db->loadObjectList();
	        
	        return $pages;
	    }
	    catch (Exception $e)
	    {
	        return null;
	    }
	}
	
	public function getItems ()
	{
		$items = parent::getItems();
		$surveyId = (int) $this->getState('filter.survey_id');
		
		if(empty($items))
		{
		    return false;
		}
		
		$questionIds = $this->initSurveyQuestions($items);
		$hiddenQns = $this->processRules($items, $surveyId, $questionIds);
		$this->loadSurveyResponse($items, $hiddenQns);
		$this->processContentPlaceholders($items);
		$this->laodSurveyLanguage($surveyId, $items);
		
		// for results, do not show questions hidden with conditional rules.
	    foreach($hiddenQns as $hiddenQn)
	    {
	        foreach($items as &$item)
	        {
	            if($item->id == $hiddenQn)
	            {
	                $item->hidden = true;
	                break;
	            }
	        }
	    }
		
		return $items;
	}
	
	private function initSurveyQuestions(&$items)
	{
	    $questionIds = array();
	    foreach ($items as &$item)
	    {
	        $questionIds[] = $item->id;
	        $item->answers = array();
	        $item->columns = array();
	        $item->responses = array();
	        
	        $params = new JRegistry();
	        $params->loadString($item->params);
	        $item->params = $params;
	        $item->hidden = false;
	        $item->rules = array();
	    }
	    
	    $questionIds = implode(',', $questionIds);
	    $answers = array();
	    
	    $db = $this->_db;
	    $query = $db->getQuery(true)
	    ->select('a.id, a.answer_label as title, a.question_id, a.answer_type, a.sort_order, a.image')
	    ->from('#__survey_answers AS a')
	    ->where('a.question_id IN ('.$questionIds.')')
	    ->order('a.sort_order ASC');
	    
	    $db->setQuery($query);
	    
	    try
	    {
	        $answers = $db->loadObjectList();
	    }
	    catch (Exception $e)
	    {
	        // TODO: Something went wrong, with DB
	    }
	    
	    if(!empty($answers))
	    {
	        foreach ($answers as &$answer)
	        {
	            foreach ($items as &$item)
	            {
	                if($answer->question_id == $item->id)
	                {
	                    if($answer->answer_type == 'y')
	                    {
	                        $item->columns[] = $answer;
	                    }
	                    else
	                    {
	                        $item->answers[] = $answer;
	                    }
	                    break;
	                }
	            }
	            reset($items);
	        }
	        reset($answers);
	    }
	    
	    return $questionIds;
	}
	
	private function processRules(&$items, $surveyId, $questionIds)
	{
	    // get the rules
	    JLoader::import('rules', JPATH_ADMINISTRATOR.'/components/com_communitysurveys/models');
	    $rulesModel	= JModelLegacy::getInstance( 'rules', 'CommunitySurveysModel' );
	    $rulesModel->getState();
	    $rulesModel->setState('filter.survey_id', $surveyId);
	    $rulesModel->setState('filter.question_id', $questionIds);
	    $rawrules = $rulesModel->getItems();
	    $hiddenQns = array();
	    $rules = array();
	    
	    if(!empty($rawrules))
	    {
	        foreach ($rawrules as $rawrule)
	        {
	            $rule = json_decode($rawrule->rulecontent);
	            $rule = (object)array_merge((array)$rawrule, (array)$rule);
	            $rules[] = $rule;
	        }
	        
	        foreach ($rules as $rule)
	        {
	            foreach ($items as &$item)
	            {
	                if($item->id == $rule->question_id)
	                {
	                    if(isset($rule->question) && $rule->question > 0)
	                    {
	                        reset($items);
	                        foreach ($items as &$item2)
	                        {
	                            if($item2->id == $rule->question)
	                            {
	                                $hiddenQns[] = $item2->id;
	                                switch ($rule->name)
	                                {
	                                    case 'answered':
	                                        $item->rule_answered[] = (int) $rule->question;
	                                        break;
	                                        
	                                    case 'selected':
	                                        if(!empty($rule->column_id))
	                                        {
	                                            $item->rule_selected[$rule->answer_id][$rule->column_id][] = (int) $rule->question;
	                                        }
	                                        else
	                                        {
	                                            $item->rule_selected[$rule->answer_id][] = (int) $rule->question;
	                                        }
	                                        
	                                        break;
	                                }
	                                break;
	                            }
	                        }
	                    }
	                    else if(!empty($rule->finalize) && $rule->finalize > 0)
	                    {
	                        if($item->id == $rule->question_id)
	                        {
	                            switch ($rule->name)
	                            {
	                                case 'answered':
	                                    $item->rule_answered[] = -1;
	                                    break;
	                                    
	                                case 'selected':
	                                    if(!empty($rule->column_id))
	                                    {
	                                        $item->rule_selected[$rule->answer_id][$rule->column_id][] = -1;
	                                    }
	                                    else
	                                    {
	                                        $item->rule_selected[$rule->answer_id][] = -1;
	                                    }
	                                    break;
	                            }
	                        }
	                    }
	                    else if(!empty($rule->page) && $rule->page > 0)
	                    {
	                        if($item->id == $rule->question_id)
	                        {
	                            switch ($rule->name)
	                            {
	                                case 'answered':
	                                    $item->rule_skip[0] = (int) $rule->page;
	                                    break;
	                                    
	                                case 'selected':
	                                    if(!empty($rule->column_id))
	                                    {
	                                        $item->rule_skip[$rule->answer_id][$rule->column_id] = (int) $rule->page;
	                                    }
	                                    else
	                                    {
	                                        $item->rule_skip[$rule->answer_id] = (int) $rule->page;
	                                    }
	                                    break;
	                            }
	                        }
	                    }
	                    
	                    $item->rules[] = $rule;
	                    break;
	                }
	            }
	            reset($items);
	        }
	        
	        $hiddenQns = array_unique($hiddenQns);
	    }
	    
	    return $hiddenQns;
	}
	
	private function loadSurveyResponse(&$items, &$hiddenQns)
	{
	    $responseId = (int) $this->getState('filter.response_id');
	    if($responseId)
	    {
	        $db = $this->getDbo();
	        $query = $db->getQuery(true)
	        ->select('a.question_id, a.answer_id, a.column_id, a.free_text')
	        ->from('#__survey_response_details AS a')
	        ->where('a.response_id = '.$responseId);
	        
	        $db->setQuery($query);
	        $responses = array();
	        
	        try
	        {
	            $responses = $db->loadObjectList();
	        }
	        catch (Exception $e)
	        {
	            // TODO: Something went wrong, with DB
	        }
	        
	        $finalized = false;
	        $skipToPage = 0;
	        $activePage = 0;
	        
	        if(!empty($responses))
	        {
	            foreach ($items as &$item)
	            {
	                if($finalized && $finalized != $item->page_order)
	                {
	                    $hiddenQns[] = $item->id;
	                    continue;
	                }
	                
	                // if skipToPage is set and the current item is not in the question which set conditional rule, then go to skip rules
	                if($skipToPage > 0 && $item->page_number != $activePage)
	                {
	                    // skip all items until the skipped page is reached
	                    if($skipToPage != $item->page_number)
	                    {
	                        $hiddenQns[] = $item->id;
	                        continue;
	                    }
	                    
	                    // now we are in the skipped page, so reset the flags
	                    $skipToPage = 0;
	                    $activePage = 0;
	                }
	                
	                foreach ($responses as $response)
	                {
	                    if($item->id != $response->question_id)
	                    {
	                        continue;
	                    }
	                    
	                    $item->responses[] = $response;
	                    
	                    // check if the question is hidden using conditional rules
	                    // remove questions from $hiddenQns if the answer is selected in the response
	                    if(!empty($item->rule_selected))
	                    {
	                        if($item->question_type == CS_GRID_RADIO || $item->question_type == CS_GRID_CHECKBOX)
	                        {
	                            if(!empty($item->rule_selected[$response->answer_id][$response->column_id]))
	                            {
	                                if($item->rule_selected[$response->answer_id][$response->column_id][0] == -1)
	                                {
	                                    $finalized = (int) $item->page_order;
	                                }
	                                else
	                                {
	                                    // Get all items from hiddenQns that are not present in the conditioanlly shown list of rule_selected
	                                    // $hiddenQns = array_diff($hiddenQns, $item->rule_selected[$response->answer_id][$response->column_id]);
	                                }
	                            }
	                        }
	                        else
	                        {
	                            if(!empty($item->rule_selected[$response->answer_id]))
	                            {
	                                if(!empty($item->rule_selected[$response->answer_id][0]) && $item->rule_selected[$response->answer_id][0] == -1)
	                                {
	                                    $finalized = (int) $item->page_order;
	                                }
	                                else
	                                {
	                                    // Get all items from hiddenQns that are not present in the conditioanlly shown list of rule_selected
	                                    // $hiddenQns = array_diff($hiddenQns, $item->rule_selected[$response->answer_id]);
	                                }
	                            }
	                        }
	                    }
	                    
	                    if(!empty($item->rule_answered))
	                    {
	                        if($item->rule_answered[0] == -1)
	                        {
	                            $finalized = (int) $item->page_order;
	                        }
	                        else
	                        {
	                            // Get all items from hiddenQns that are not present in the conditioanlly shown list of rule_answered
	                            //$hiddenQns = array_diff($hiddenQns, $item->rule_answered);
	                        }
	                    }
	                    
	                    if(!empty($item->rule_skip))
	                    {
	                        $activePage = (int) $item->page_number;
	                        if(!empty($item->rule_skip[0]))
	                        {
	                            $skipToPage = $item->rule_skip[0];
	                        }
	                        else if(!empty($item->rule_skip[$response->answer_id][$response->column_id]))
	                        {
	                            $skipToPage = $item->rule_skip[$response->answer_id][$response->column_id];
	                        }
	                        else if(!empty($item->rule_skip[$response->answer_id]))
	                        {
	                            $skipToPage = $item->rule_skip[$response->answer_id];
	                        }
	                    }
	                } // RESPONSES LOOP
	            } // ITEMS LOOP
	        } // ENDIF RESPONSES
	    } // ENDIF RESPONSEID
	}
	
	private function processContentPlaceholders(&$items)
	{
	    if($this->getState('question.replace_placeholders'))
	    {
	        // Replace placeholders
	        foreach ($items as &$item)
	        {
	            $item->title = preg_replace_callback('/\{QID:(.*?)\}/', function($matches) use ($item)
	            {
	                $questionId = intval(trim($matches[1]));
	                if(empty($questionId))
	                {
	                    return '';
	                }
	                
	                $db = $this->_db;
	                $query = $db->getQuery(true)
	                ->select('a.answer_label answer_val, b.answer_label column_val, r.free_text')
	                ->from('#__survey_response_details r')
	                ->leftJoin('#__survey_answers a on a.id = r.answer_id')
	                ->leftJoin('#__survey_answers b on b.id = r.column_id')
	                ->where('r.question_id = ' . $questionId);
	                $db->setQuery($query);
	                
	                $return = array();
	                
	                try
	                {
	                    $response = $db->loadObject();
	                    if(!empty($response->answer_val))
	                    {
	                        $return[] = $response->answer_val;
	                    }
	                    
	                    if(!empty($response->column_val))
	                    {
	                        $return[] = $response->column_val;
	                    }
	                    
	                    if(!empty($response->free_text))
	                    {
	                        $return[] = $response->free_text;
	                    }
	                }
	                catch(Exception $e)
	                {
	                    // nothing
	                }
	                
	                return implode(',', $return);
	            }, $item->title);
	        }
	    }
	}
	
	private function laodSurveyLanguage($surveyId, $items)
	{
	    $app = JFactory::getApplication();
	    $language = $app->input->getCmd('lang', JFactory::getLanguage()->getTag());
	    if(empty($language))
	    {
	        return;
	    }
	    
	    JLoader::import('language', JPATH_ADMINISTRATOR.'/components/com_communitysurveys/models');
	    $languageModel = JModelAdmin::getInstance( 'language', 'CommunitySurveysModel' );
	    
	    $translations = $languageModel->getSurveyTranslations($surveyId, $language);
	    if(empty($translations))
	    {
	        return;
	    }
	    
	    $questionFields = array(CS_TRANSLATION_QUESTION_TITLE, CS_TRANSLATION_QUESTION_DESC, CS_TRANSLATION_ANSWER_TITLE);
	    foreach ($items as &$item)
	    {
    	    foreach ($translations as $translation)
    	    {
    	        if(!in_array($translation->item_type, $questionFields) || empty($translation->translation))
    	        {
    	            continue;
    	        }

    	        if($translation->parent_id == $item->id && $translation->item_type == CS_TRANSLATION_ANSWER_TITLE)
    	        {
    	            $found = false;
    	            foreach ($item->answers as &$answer)
    	            {
    	                if($answer->id == $translation->item_id)
    	                {
    	                    $answer->title = $translation->translation;
    	                    $found = true;
    	                    break;
    	                }
    	            }
    	            
    	            if($found)
    	            {
    	                continue;
    	            }

    	            foreach ($item->columns as &$column)
    	            {
    	                if($column->id == $translation->item_id)
    	                {
    	                    $column->title = $translation->translation;
    	                    break;
    	                }
    	            }
    	        }
    	        else if($translation->item_id == $item->id)
    	        {
    	            switch ($translation->item_type) {
    	                case CS_TRANSLATION_QUESTION_TITLE:
    	                    $item->title = $translation->translation;
    	                    break;
    	                    
    	                case CS_TRANSLATION_QUESTION_DESC:
    	                    $item->description = $translation->translation;
    	                    break;
    	            }
    	        }
    	    }
	    }
	}
	
	private function getUser()
	{
		$user = $this->getState('user');
		if(empty($user))
		{
			$user = JFactory::getUser();
		}
	
		return $user;
	}
}
