<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die();


$categories = JHtml::_('category.options', 'com_communitysurveys');
?>
<div id="cj-wrapper">
	<div class="container-fluid survey-wrapper nospace-left no-space-left no-space-right">
		<div class="row-fluid">
			<div class="span12">
			
				<form id="adminForm" action="<?php echo JRoute::_('index.php?option='.Q_APP_NAME.'&view=approval&task=list');?>" method="post" name="adminForm">
					<div class="well well-small clearfix">
						<div class="pull-right">
							<select name="catid" size="1" onchange="this.form.submit();">
								<option><?php echo JText::_('LBL_FILTER_BY_CATEGORY');?></option>
								<?php foreach ($categories as $category):?>
								<option value="<?php echo $category->value?>"<?php echo $this->lists['catid'] == $category->value ? ' selected="selected"' : '';?>>
									<?php echo $this->escape($category->text)?>
								</option>
								<?php endforeach;?>
							</select>
						</div>
						
						<div class="input-append">
							<input class="input-medium" name="search" type="text" value="<?php echo CjLibUtils::escape($this->lists['search']);?>" placeholder="<?php echo JText::_('LBL_SEARCH');?>">
							<div class="btn-group">
								<button class="btn" tabindex="-1" type="submit"><?php echo JText::_('LBL_SEARCH');?></button>
								<button class="btn dropdown-toggle" data-toggle="dropdown" tabindex="-1">
									&nbsp;<span class="caret"></span>
								</button>
								<ul class="dropdown-menu">
									<li><a class="btn-reset" href="#" onclick="return false;"><?php echo JText::_('LBL_RESET');?></a></li>
								</ul>
							</div>
						</div>
					</div>
					
					<table class="table table-hover table-striped">
						<thead>
							<tr>
								<th width="20"><?php echo JText::_( '#' ); ?></th>
								<th width="20"><input type="checkbox" name="toggle" value="" onclick="Joomla.checkAll(this);" /></th>
								<th><?php echo JHTML::_( 'grid.sort', JText::_( 'LBL_TITLE' ), 'a.title', $this->lists['order_dir'], $this->lists['order']); ?></th>
								<th width="10%"><?php echo JHTML::_( 'grid.sort', JText::_( 'LBL_CATEGORY' ), 'c.title', $this->lists['order_dir'], $this->lists['order']); ?></th>
								<th width="8%"><?php echo JHTML::_( 'grid.sort', JText::_( 'LBL_USERNAME' ), 'u.username', $this->lists['order_dir'], $this->lists['order']); ?></th>
								<th width="12%"><?php echo JHTML::_( 'grid.sort', JText::_( 'LBL_CREATED_ON' ), 'a.created', $this->lists['order_dir'], $this->lists['order']); ?></th>
								<th width="4%"><?php echo JHTML::_( 'grid.sort', JText::_( 'LBL_RESPONSES' ), 'a.responses', $this->lists['order_dir'], $this->lists['order']);?></th>
								<th width="4%"><?php echo JHTML::_( 'grid.sort', JText::_( 'LBL_PUBLISHED' ), 'a.published', $this->lists['order_dir'], $this->lists['order']); ?></th>
								<th width="5%"><?php echo JText::_('LBL_PREVIEW');?></th>
								<th width="20"><?php echo JText::_('ID');?></th>
							</tr>
						</thead>
						<tbody>
							<?php foreach ($this->surveys as $i=>$row):?>
							<tr>
								<td><?php echo $this->pagination->getRowOffset( $i ); ?></td>
								<td><?php echo JHTML::_( 'grid.id', $i, $row->id );?></td>
								<td><a href="<?php echo JRoute::_('index.php?option='.Q_APP_NAME.'&view=surveys&task=edit&id='.$row->id)?>"><?php echo $this->escape($row->title);?></a></td>
								<td><?php echo $this->escape($row->category); ?></td>
								<td><?php echo $this->escape($row->name).' ('.$this->escape($row->username).')';?></td>
								<td><?php echo JHTML::Date($row->created, JText::_('DATE_FORMAT_LC2')); ?></td>
								<td class="center"><?php echo $this->escape($row->responses); ?></td>
								<td class="center">
									<a 
										class="btn btn-mini <?php echo $row->published == 1 ? 'btn-success' : ($row->published == 2 ? 'btn-warning' : 'btn-danger');?> tooltip-hover btn-publish" 
										title="<?php echo $row->published == 1 ? JText::_('LBL_PUBLISHED') : ($row->published == 2 ? JText::_('LBL_STATUS_PENDING') : JText::_('LBL_UNPUBLISHED'));?>"
										href="#"
										onclick="return false;">
										<i class="icon <?php echo $row->published == 1 ? 'icon-ok' : 'icon-remove'; ?> icon-white"></i>
									</a>
									<input type="hidden" name="survey_id" value="<?php echo $row->id?>">
								</td>
								<td><a href="<?php echo JRoute::_('index.php?option='.Q_APP_NAME.'&view=approval&task=preview&id='.$row->id);?>"><?php echo JText::_('LBL_PREVIEW')?></a></td>
								<td><?php echo $row->id;?></td>
							</tr>
							<?php endforeach;?>
						</tbody>
						<tfoot>
							<tr>
								<td colspan="9"><?php echo $this->pagination->getListFooter(); ?></td>
							</tr>
						</tfoot>
					</table>
					
					<input type="hidden" name="task" value="list" />
					<input type="hidden" name="boxchecked" value="0" />
					<input type="hidden" name="filter_order" value="<?php if($this->lists['order']) echo $this->lists['order']; ?>" />
					<input type="hidden" name="filter_order_Dir" value="<?php if($this->lists['order_dir']) echo $this->lists['order_dir']; ?>" />
					<input type="hidden" name="cjsurvey_page_id" id="cjsurvey_page_id" value="surveys">
				</form>
				
				<div style="display: none;">
					<div id="url-publish-survey"><?php echo JRoute::_('index.php?option='.Q_APP_NAME.'&view=surveys&task=publish_item');?></div>
					<div id="url-unpublish-survey"><?php echo JRoute::_('index.php?option='.Q_APP_NAME.'&view=surveys&task=unpublish_item');?></div>
				</div>
							
				<div id="message-modal" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
						<h3 id="myModalLabel"><?php echo JText::_('LBL_ALERT');?></h3>
					</div>
					<div class="modal-body"></div>
					<div class="modal-footer">
						<button class="btn" data-dismiss="modal" aria-hidden="true"><?php echo JText::_('JTOOLBAR_CLOSE');?></button>
					</div>
				</div>
				
			</div>
		</div>
	</div>
</div>