<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die();


class CommunitySurveysViewApproval extends JViewLegacy {
	
	protected $params;
	
	function display($tpl = null) {
		
		JToolBarHelper::title(JText::_('COM_COMMUNITYSURVEYS_MENU').': <small><small>[ ' . JText::_('COM_COMMUNITYSURVEYS_SURVEYS') .' ]</small></small>', 'logo.png');
		
		$app = JFactory::getApplication();
		$model = $this->getModel();
		
		/********************************** PARAMS *****************************/
		$this->params = JComponentHelper::getParams(Q_APP_NAME);
		/********************************** PARAMS *****************************/
		
		switch ($this->action){
			
			case 'list':
				
				$app->input->post->set('state', 2);
				$result = $model->get_surveys();
				$surveys = !empty($result['surveys']) ? $result['surveys'] : array();
				
				$users_model = $this->getModel('users');
				$users = $users_model->get_all_active_users();
				
				$this->assignRef('surveys', $surveys);
				$this->assignRef('categories', $categories);
				$this->assignRef('users', $users);
				$this->assignRef('pagination', $result['pagination']);
				$this->assignRef('lists', $result['lists']);
				
				JToolBarHelper::custom('refresh', 'refresh.png', 'refresh.png', JText::_('LBL_REFRESH'), false, false);
				JToolBarHelper::divider();
				JToolBarHelper::publish();
				JToolBarHelper::unpublish();
				JToolBarHelper::deleteList();
				
				break;
				
			case 'preview':
				
				$id = $app->input->getInt('id');
				$survey = $model->get_survey_details($id, true);
				$this->assignRef('survey', $survey);
				
				JToolBarHelper::publish();
				JToolBarHelper::unpublish();
				JToolBarHelper::cancel();
				
				break;
		}
		
		parent::display($tpl);
	}	
}