<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();


JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');

JHtml::_('bootstrap.tooltip');
CJLib::behavior('bscore');
CJLib::behavior('fontawesome');

$app		= JFactory::getApplication();
$user		= JFactory::getUser();
$userId		= $user->id;
$rowClass   = CS_MAJOR_VERSION < 4 ? 'row-fluid' : 'row';
$span 		= !empty( $this->sidebar) ? 'col-md-10' : 'col-md-12';
?>
<div id="cj-wrapper" class="<?php echo $rowClass;?>">
	<?php if (!empty( $this->sidebar)) : ?>
	<div id="j-sidebar-container" class="col-md-2">
		<?php echo $this->sidebar; ?>
	</div>
	<?php endif;?>
	<div id="j-main-container" class="<?php echo $span;?>">
		<div class="<?php echo $rowClass;?>">
			<div class="span8 col-md-8">
				<div class="panel panel-default">
					<div class="panel-heading">
						<strong><i class="fa fa-refresh"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_RECENT_SURVEYS');?></strong>
					</div>
					<?php if(!$this->recent):?>
					<div class="panel-body">
						<?php echo JText::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
					</div>
					<?php else:?>
					<table class="table table-striped table-hover">
						<caption></caption>
						<thead>
							<tr>
								<th><?php echo JText::_('JGLOBAL_TITLE');?></th>
								<th width="10%" class="nowrap hidden-phone"><?php echo JText::_('JAUTHOR');?></th>
								<th width="5%" class="nowrap hidden-phone"><?php echo JText::_('JGRID_HEADING_LANGUAGE');?></th>
								<th width="10%" class="nowrap hidden-phone"><?php echo JText::_('JDATE');?></th>
								<th width="10%"><?php echo JText::_('COM_COMMUNITYSURVEYS_RESPONSES_LABEL');?></th>
								<th width="1%" class="nowrap hidden-phone"><?php echo JText::_('JGRID_HEADING_ID');?></th>
							</tr>
						</thead>
						<tbody>
						<?php foreach ($this->recent as $i => $item) :
							$canEdit    = $user->authorise('core.edit',       'com_communitysurveys.survey.'.$item->id);
							$canCheckin = $user->authorise('core.manage',     'com_checkin') || $item->checked_out == $userId || $item->checked_out == 0;
							$canEditOwn = $user->authorise('core.edit.own',   'com_communitysurveys.survey.'.$item->id) && $item->created_by == $userId;
							$canChange  = $user->authorise('core.edit.state', 'com_communitysurveys.survey.'.$item->id) && $canCheckin;
							?>
							<tr>
								<td class="has-context">
									<div>
										<?php if ($item->checked_out) : ?>
											<?php echo JHtml::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'surveys.', $canCheckin); ?>
										<?php endif; ?>
										<?php if ($item->language == '*'):?>
											<?php $language = JText::alt('JALL', 'language'); ?>
										<?php else:?>
											<?php $language = $item->language_title ? $this->escape($item->language_title) : JText::_('JUNDEFINED'); ?>
										<?php endif;?>
										<?php if ($canEdit || $canEditOwn) : ?>
											<a href="<?php echo JRoute::_('index.php?option=com_communitysurveys&task=survey.edit&id=' . $item->id); ?>" title="<?php echo JText::_('JACTION_EDIT'); ?>">
												<?php echo $this->escape($item->title); ?></a>
										<?php else : ?>
											<span title="<?php echo JText::sprintf('JFIELD_ALIAS_LABEL', $this->escape($item->alias)); ?>"><?php echo $this->escape($item->title); ?></span>
										<?php endif; ?>
										<div class="small">
											<?php echo JText::_('JCATEGORY') . ": " . $this->escape($item->category_title); ?>
										</div>
									</div>
								</td>
								<td class="small hidden-phone">
									<a href="<?php echo JRoute::_('index.php?option=com_users&task=user.edit&id='.(int) $item->created_by); ?>" title="<?php echo JText::_('JAUTHOR'); ?>">
										<?php echo $this->escape($item->author_name); ?>
									</a>
								</td>
								<td class="small hidden-phone">
									<?php if ($item->language == '*'):?>
										<?php echo JText::alt('JALL', 'language'); ?>
									<?php else:?>
										<?php echo $item->language_title ? $this->escape($item->language_title) : JText::_('JUNDEFINED'); ?>
									<?php endif;?>
								</td>
								<td class="nowrap small hidden-phone">
									<?php echo JHtml::_('date', $item->created, JText::_('DATE_FORMAT_LC4')); ?>
								</td>
								<td class="center">
									<?php echo (int) $item->responses; ?>
								</td>
								<td class="center hidden-phone">
									<?php echo (int) $item->id; ?>
								</td>
							</tr>
							<?php endforeach; ?>
						</tbody>
					</table>
					<?php endif;?>
				</div>
				
				<div class="panel panel-default">
					<div class="panel-heading">
						<strong><i class="fa fa-refresh"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_TRENDING_SURVEYS');?></strong>
					</div>
					<?php if(!$this->trending):?>
					<div class="panel-body">
						<?php echo JText::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
					</div>
					<?php else:?>
					<table class="table table-striped table-hover">
						<caption></caption>
						<thead>
							<tr>
								<th><?php echo JText::_('JGLOBAL_TITLE');?></th>
								<th width="10%" class="nowrap hidden-phone"><?php echo JText::_('JAUTHOR');?></th>
								<th width="5%" class="nowrap hidden-phone"><?php echo JText::_('JGRID_HEADING_LANGUAGE');?></th>
								<th width="10%" class="nowrap hidden-phone"><?php echo JText::_('JDATE');?></th>
								<th width="10%"><?php echo JText::_('COM_COMMUNITYSURVEYS_RESPONSES_LABEL');?></th>
								<th width="1%" class="nowrap hidden-phone"><?php echo JText::_('JGRID_HEADING_ID');?></th>
							</tr>
						</thead>
						<tbody>
						<?php foreach ($this->trending as $i => $item) :
							$canEdit    = $user->authorise('core.edit',       'com_communitysurveys.survey.'.$item->id);
							$canCheckin = $user->authorise('core.manage',     'com_checkin') || $item->checked_out == $userId || $item->checked_out == 0;
							$canEditOwn = $user->authorise('core.edit.own',   'com_communitysurveys.survey.'.$item->id) && $item->created_by == $userId;
							$canChange  = $user->authorise('core.edit.state', 'com_communitysurveys.survey.'.$item->id) && $canCheckin;
							?>
							<tr>
								<td class="has-context">
									<div>
										<?php if ($item->checked_out) : ?>
											<?php echo JHtml::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'surveys.', $canCheckin); ?>
										<?php endif; ?>
										<?php if ($item->language == '*'):?>
											<?php $language = JText::alt('JALL', 'language'); ?>
										<?php else:?>
											<?php $language = $item->language_title ? $this->escape($item->language_title) : JText::_('JUNDEFINED'); ?>
										<?php endif;?>
										<?php if ($canEdit || $canEditOwn) : ?>
											<a href="<?php echo JRoute::_('index.php?option=com_communitysurveys&task=survey.edit&id=' . $item->id); ?>" title="<?php echo JText::_('JACTION_EDIT'); ?>">
												<?php echo $this->escape($item->title); ?></a>
										<?php else : ?>
											<span title="<?php echo JText::sprintf('JFIELD_ALIAS_LABEL', $this->escape($item->alias)); ?>"><?php echo $this->escape($item->title); ?></span>
										<?php endif; ?>
										<div class="small">
											<?php echo JText::_('JCATEGORY') . ": " . $this->escape($item->category_title); ?>
										</div>
									</div>
								</td>
								<td class="small hidden-phone">
									<a href="<?php echo JRoute::_('index.php?option=com_users&task=user.edit&id='.(int) $item->created_by); ?>" title="<?php echo JText::_('JAUTHOR'); ?>">
										<?php echo $this->escape($item->author_name); ?>
									</a>
								</td>
								<td class="small hidden-phone">
									<?php if ($item->language == '*'):?>
										<?php echo JText::alt('JALL', 'language'); ?>
									<?php else:?>
										<?php echo $item->language_title ? $this->escape($item->language_title) : JText::_('JUNDEFINED'); ?>
									<?php endif;?>
								</td>
								<td class="nowrap small hidden-phone">
									<?php echo JHtml::_('date', $item->created, JText::_('DATE_FORMAT_LC4')); ?>
								</td>
								<td class="center">
									<?php echo (int) $item->responses; ?>
								</td>
								<td class="center hidden-phone">
									<?php echo (int) $item->id; ?>
								</td>
							</tr>
							<?php endforeach; ?>
						</tbody>
					</table>
					<?php endif;?>
				</div>
			</div>
			<div class="span4 col-md-4">
				<div class="panel panel-default">
					<div class="panel-heading">
						<strong><i class="fa fa-bullhorn"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_TITLE_VERSION');?></strong>
					</div>
					<table class="table table-striped">
						<tbody>
							<tr>
								<td colspan="2">
									<p>If you use CommunitySurveys, please post a rating and a review at the Joomla Extension Directory</p>
									<a class="btn btn-info" href="http://extensions.joomla.org/write-review/review/add?extension_id=5369" target="_blank">
										<i class="icon-share icon-white"></i> <span style="color: white">Post Your Review</span>
									</a>
								</td>
							</tr>
							<tr>
								<th><?php echo JText::_('COM_COMMUNITYSURVEYS_INSTALLED_VERSION');?>:</th>
								<td><?php echo CS_CURR_VERSION;?></td>
							<tr>
							<tr>
    							<th>Changelog</th>
    							<td><a href="http://wiki.corejoomla.com/Community_Surveys_Change_Log" target="_blank"><i class="fa fa-external-link"></i> Changelog</a></td>
    						</tr>
							<?php if(!empty($this->version)):?>
							<tr>
								<th>Latest Version:</th>
								<td><?php echo $this->version['version'];?></td>
							</tr>
							<tr>
								<th>Latest Version Released On:</th>
								<td><?php echo $this->version['released'];?></td>
							</tr>
							<tr>
								<th>CjLib Version</th>
								<td><?php echo CJLIB_VER;?></td>
							</tr>
							<tr>
								<td colspan="2" style="text-align: center;">
									<?php if($this->version['status'] == 1):?>
									<a href="http://www.corejoomla.com/downloads.html" target="_blank" class="btn btn-danger">
										<i class="icon-download icon-white"></i> <span style="color: white">Please Update</span>
									</a>
									<?php else:?>
									<a href="#" class="btn btn-success"><i class="icon-ok icon-white"></i> <span style="color: white">Up-to date</span></a>
									<?php endif;?>
								</td>
							</tr>
							<?php endif;?>
						</tbody>
					</table>
				</div>
				<div class="panel panel-default">
					<div class="panel-heading"><strong>Credits: </strong></div>
					<div class="panel-body">
						<div>CommunitySurveys is a free software released under Gnu/GPL license. Copyright© 2009-17 corejoomla.com</div>
						<div>Core Components: Bootstrap, jQuery, FontAwesome and ofcourse Joomla<sup>&reg;</sup>.</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>