<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class CommunitySurveysViewEmail extends JViewLegacy
{
	protected $form;

	protected $item;

	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->form		= $this->get('Form');
		$this->item		= $this->get('Item');
		$this->state	= $this->get('State');
		$this->canDo	= JHelperContent::getActions('com_communitysurveys', 'email', $this->item->id);

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
		    throw new Exception(implode('\n', $errors), 500);
		}

		if ($this->getLayout() == 'modal')
		{
			$this->form->setFieldAttribute('language', 'readonly', 'true');
			$this->form->setFieldAttribute('catid', 'readonly', 'true');
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);
		$user		= JFactory::getUser();
		$userId		= $user->get('id');
		$isNew		= ($this->item->id == 0);
		$checkedOut	= !($this->item->checked_out == 0 || $this->item->checked_out == $userId);

		// Built the actions for new and existing records.
		$canDo		= $this->canDo;
			JToolbarHelper::title(JText::_('COM_COMMUNITYSURVEYS_PAGE_' . ($checkedOut ? 'VIEW_EMAIL_TEMPLATE' : 'EDIT_EMAIL_TEMPLATE')), 'pencil-2 email-add');

		// For new records, check the create permission.
		if ($isNew && (count($user->getAuthorisedCategories('com_communitysurveys', 'core.create')) > 0))
		{
			JToolbarHelper::apply('email.apply');
			JToolbarHelper::save('email.save');
			JToolbarHelper::cancel('email.cancel');
		}
		else
		{
			// Can't save the record if it's checked out.
			if (!$checkedOut)
			{
				// Since it's an existing record, check the edit permission, or fall back to edit own if the owner.
				if ($canDo->get('core.edit') || ($canDo->get('core.edit.own') && $this->item->created_by == $userId))
				{
					JToolbarHelper::apply('email.apply');
					JToolbarHelper::save('email.save');
				}
			}

			if ($this->state->params->get('save_history', 0) && $canDo->get('core.edit'))
			{
				JToolbarHelper::versions('com_communitysurveys.email', $this->item->id);
			}

			JToolbarHelper::cancel('email.cancel', 'JTOOLBAR_CLOSE');
		}
	}
}
