<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');

JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

$app		= JFactory::getApplication();
$user		= JFactory::getUser();
$userId		= $user->get('id');
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$archived	= $this->state->get('filter.published') == 2 ? true : false;
$trashed	= $this->state->get('filter.published') == -2 ? true : false;
$saveOrder	= $listOrder == 'a.ordering';
$span 		= !empty( $this->sidebar) ? 'col-md-10' : 'col-md-12';

if ($saveOrder)
{
	$saveOrderingUrl = 'index.php?option=com_communitysurveys&task=emails.saveOrderAjax&tmpl=component';
	JHtml::_('sortablelist.sortable', 'emailList', 'adminForm', strtolower($listDirn), $saveOrderingUrl);
}

$sortFields = $this->getSortFields();
?>
<script type="text/javascript">
	Joomla.orderTable = function()
	{
		table = document.getElementById("sortTable");
		direction = document.getElementById("directionTable");
		order = table.options[table.selectedIndex].value;
		if (order != '<?php echo $listOrder; ?>')
		{
			dirn = 'asc';
		}
		else
		{
			dirn = direction.options[direction.selectedIndex].value;
		}
		Joomla.tableOrdering(order, dirn, '');
	}
</script>
<div class="row" id="cj-wrapper">
    <?php if (!empty( $this->sidebar)) : ?>
    <div id="j-sidebar-container" class="col-md-2">
    	<?php echo $this->sidebar; ?>
    </div>
    <?php endif;?>
    <div class="<?php echo $span;?>">
    	<div id="j-main-container">
			<form action="<?php echo JRoute::_('index.php?option=com_communitysurveys&view=emails'); ?>" method="post" name="adminForm" id="adminForm">
        		<?php
        		// Search tools bar
        		echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this));
        		?>
        		<?php if (empty($this->items)) : ?>
        			<div class="alert alert-no-items">
        				<?php echo JText::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
        			</div>
        		<?php else : ?>
        			<table class="table table-striped" id="emailList">
        				<thead>
        					<tr>
        						<th width="1%" class="nowrap center hidden-phone">
        							<?php echo JHtml::_('searchtools.sort', '', 'a.ordering', $listDirn, $listOrder, null, 'asc', 'JGRID_HEADING_ORDERING', 'icon-menu-2'); ?>
        						</th>
        						<th width="1%" class="hidden-phone">
        							<?php echo JHtml::_('grid.checkall'); ?>
        						</th>
        						<th width="1%" style="min-width:55px" class="nowrap center">
        							<?php echo JHtml::_('searchtools.sort', 'JSTATUS', 'a.published', $listDirn, $listOrder); ?>
        						</th>
        						<th>
        							<?php echo JHtml::_('searchtools.sort', 'JGLOBAL_TITLE', 'a.title', $listDirn, $listOrder); ?>
        						</th>
        						<th width="20%" class="nowrap hidden-phone">
        							<?php echo JHtml::_('searchtools.sort', 'COM_COMMUNITYSURVEYS_EMAIL_TYPE', 'a.email_type', $listDirn, $listOrder); ?>
        						</th>
        						<th width="10%" class="nowrap hidden-phone">
        							<?php echo JHtml::_('searchtools.sort',  'JGRID_HEADING_ACCESS', 'a.access', $listDirn, $listOrder); ?>
        						</th>
        						<th width="5%" class="nowrap hidden-phone">
        							<?php echo JHtml::_('searchtools.sort', 'JGRID_HEADING_LANGUAGE', 'language', $listDirn, $listOrder); ?>
        						</th>
        						<th width="1%" class="nowrap hidden-phone">
        							<?php echo JHtml::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
        						</th>
        					</tr>
        				</thead>
        				<tbody>
        				<?php foreach ($this->items as $i => $item) :
        					$item->max_ordering = 0; //??
        					$ordering   = ($listOrder == 'a.ordering');
        					$canEdit    = $user->authorise('core.edit',       'com_communitysurveys');
        					$canCheckin = $user->authorise('core.manage',     'com_checkin') || $item->checked_out == $userId || $item->checked_out == 0;
        					$canEditOwn = $user->authorise('core.edit.own',   'com_communitysurveys') && $item->created_by == $userId;
        					$canChange  = $user->authorise('core.edit.state', 'com_communitysurveys') && $canCheckin;
        					?>
        					<tr class="row<?php echo $i % 2; ?>">
        						<td class="order nowrap center hidden-phone">
        							<?php
        							$iconClass = '';
        							if (!$canChange)
        							{
        								$iconClass = ' inactive';
        							}
        							elseif (!$saveOrder)
        							{
        								$iconClass = ' inactive tip-top hasTooltip" title="' . JHtml::tooltipText('JORDERINGDISABLED');
        							}
        							?>
        							<span class="sortable-handler<?php echo $iconClass ?>">
        								<i class="icon-menu"></i>
        							</span>
        							<?php if ($canChange && $saveOrder) : ?>
        								<input type="text" style="display:none" name="order[]" size="5" value="<?php echo $item->ordering; ?>" class="width-20 text-area-order " />
        							<?php endif; ?>
        						</td>
        						<td class="center hidden-phone">
        							<?php echo JHtml::_('grid.id', $i, $item->id); ?>
        						</td>
        						<td class="center">
        							<div class="btn-group">
        								<?php echo JHtml::_('jgrid.published', $item->published, $i, 'emails.', $canChange, 'cb', '0000-00-00 00:00:00', '0000-00-00 00:00:00'); ?>
        								<?php
        								// Create dropdown items
        								$action = $archived ? 'unarchive' : 'archive';
        								JHtml::_('actionsdropdown.' . $action, 'cb' . $i, 'emails');
        
        								$action = $trashed ? 'untrash' : 'trash';
        								JHtml::_('actionsdropdown.' . $action, 'cb' . $i, 'emails');
        
        								// Render dropdown list
        								echo JHtml::_('actionsdropdown.render', $this->escape($item->title));
        								?>
        							</div>
        						</td>
        						<td class="has-context">
        							<div class="pull-left">
        								<?php if ($item->checked_out) : ?>
        									<?php echo JHtml::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'emails.', $canCheckin); ?>
        								<?php endif; ?>
        								<?php if ($item->language == '*'):?>
        									<?php $language = JText::alt('JALL', 'language'); ?>
        								<?php else:?>
        									<?php $language = $item->language_title ? $this->escape($item->language_title) : JText::_('JUNDEFINED'); ?>
        								<?php endif;?>
        								<?php if ($canEdit || $canEditOwn) : ?>
        									<a href="<?php echo JRoute::_('index.php?option=com_communitysurveys&task=email.edit&id=' . $item->id); ?>" title="<?php echo JText::_('JACTION_EDIT'); ?>">
        										<?php echo $this->escape($item->title); ?></a>
        								<?php else : ?>
        									<span><?php echo $this->escape($item->title); ?></span>
        								<?php endif; ?>
        							</div>
        						</td>
        						<td><?php echo $item->email_type;?></td>
        						<td class="small hidden-phone">
        							<?php echo $this->escape($item->access_level); ?>
        						</td>
        						<td class="small hidden-phone">
        							<?php if ($item->language == '*'):?>
        								<?php echo JText::alt('JALL', 'language'); ?>
        							<?php else:?>
        								<?php echo $item->language_title ? $this->escape($item->language_title) : JText::_('JUNDEFINED'); ?>
        							<?php endif;?>
        						</td>
        						<td class="center hidden-phone">
        							<?php echo (int) $item->id; ?>
        						</td>
        					</tr>
        					<?php endforeach; ?>
        				</tbody>
        			</table>
        		<?php endif; ?>
        		<?php echo $this->pagination->getListFooter(); ?>
        
        		<input type="hidden" name="task" value="" />
        		<input type="hidden" name="boxchecked" value="0" />
        		<?php echo JHtml::_('form.token'); ?>
			</form>
		</div>
	</div>
</div>
