<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die();


class CommunitySurveysViewImport extends JViewLegacy 
{
	protected $params;
	protected $print;
	protected $state;
		
	function display($tpl = null) {
		
		$app = JFactory::getApplication();
		$model = $this->getModel();
		$document = JFactory::getDocument();
		
		$active = $app->getMenu()->getActive();
		$this->print = $app->input->getBool('print');
		
		/********************************** PARAMS *****************************/
		$appparams = JComponentHelper::getParams(Q_APP_NAME);
		$menuParams = new JRegistry;
		
		if ($active) {
		
			$menuParams->loadString($active->params);
		}
		
		$this->params = clone $menuParams;
		$this->params->merge($appparams);
		/********************************** PARAMS *****************************/
		
		$page_heading = JText::_('COM_COMMUNITYSURVEYS_IMPORT_SURVEY');
		$document->addScript(JUri::root(true).'/media/'.Q_APP_NAME.'/js/cj.surveys.min.js');
		
		// set browser title
		$this->params->set('page_heading', $this->params->get('page_heading', $page_heading));
		$title = $this->params->get('page_title', $app->getCfg('sitename'));
		
		JToolBarHelper::title(JText::_('COM_COMMUNITYSURVEYS_MENU').': <small><small>[ ' . $page_heading .' ]</small></small>', 'logo.png');
		$document->setTitle($page_heading);
		
		parent::display($tpl);
	}
}