<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('bootstrap.tooltip');
JHtml::_('formbehavior.chosen', 'select:not(.chosen-disabled)');

$params  	= $this->params;
$layout 	= $params->get('ui_layout', 'default');
$span 		= !empty( $this->sidebar) ? 'col-md-10' : 'col-md-12';
$return     = base64_encode(JUri::getInstance());

JFactory::getLanguage()->load('joomla', JPATH_ADMINISTRATOR);
CJFunctions::load_jquery(array('libs'=>array('form'), 'custom_tag'=>true));
CjScript::_('noty', array('custom'=>true));
?>
<style>
<!--
#cj-wrapper .accordion .card-header {background-color: #f5f5f5} 
-->
</style>
<div class="row" id="cj-wrapper">
    <?php if (!empty( $this->sidebar)) : ?>
    <div id="j-sidebar-container" class="col-md-2">
    	<?php echo $this->sidebar; ?>
    </div>
    <?php endif;?>
    <div class="<?php echo $span;?>">
    	<div id="j-main-container">
    		<?php echo SurveyHelper::renderLayout($layout.'.invite', array('data'=>$this));?>
    	</div>
    	
    	<form action="<?php echo JRoute::_('index.php?option=com_communitysurveys&view=surveys');?>" method="post" name="adminForm" id="adminForm" style="display: none;">
    		<input type="hidden" name="task" value="" />
    		<input type="hidden" name="boxchecked" value="0" />
    		<input type="hidden" name="return" value="<?php echo $return;?>" />
    		<?php echo JHtml::_('form.token'); ?>
    	</form>
    </div>
</div>