<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

class CommunitySurveysViewInvite extends JViewLegacy
{
	public $items;
	public $state;

	public function display($tpl = null)
	{
		$app				= JFactory::getApplication();
		$user				= JFactory::getUser();
		
		$this->item			= $this->get('Item');
		$this->form			= $this->get('Form');
		$this->state		= $this->get('State');
		$this->keys			= $this->get('Keys');
		$this->cgroups		= $this->get('ContactGroups');
		$this->contacts		= $this->get('Contacts');
		$this->pagination	= $this->get('Pagination');
		$this->jsgroups		= $this->get('CommunityGroups');
		$this->params		= $this->state->get('params');
		$this->layout		= $this->getLayout();
		
		$this->params->set('ui_layout', CS_MAJOR_VERSION < 4 ? 'default' : 'bootstrap4');
		
		if($this->item->created_by != $user->id && !$user->authorise('core.manage', 'com_communitysurveys.survey.'.$this->item->id))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		}
		
		if ($this->getLayout() !== 'modal')
		{
			CommunitySurveysHelper::addSubmenu('surveys');
		}
		
		if($this->getLayout() !== 'modal')
		{
			$this->addToolbar();
			
			if(CS_MAJOR_VERSION == 3)
			{
			    $this->sidebar = JHtmlSidebar::render();
			}
		}
		
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 */
	protected function addToolbar()
	{
		$user  = JFactory::getUser();
		JToolbarHelper::title(JText::_('COM_COMMUNITYSURVEYS_REPORTS_TITLE'), 'stack survey');
		
		JToolbarHelper::cancel('survey.cancel');
		
		if ($user->authorise('core.admin', 'com_communitysurveys'))
		{
			JToolbarHelper::preferences('com_communitysurveys');
		}
	}
}