<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class CommunitySurveysViewLanguages extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Display the view
	 *
	 * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	 *
	 * @return  void
	 */
	public function display($tpl = null)
	{
		if ($this->getLayout() !== 'modal')
		{
			CommunitySurveysHelper::addSubmenu('surveys');
		}
		
		$app                 = JFactory::getApplication();
		$this->survey_id     = $app->input->getInt('survey_id', 0);
		
		if(!$this->survey_id) 
		{
		    throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		}
		
		$this->items         = $this->get('Items');
		$this->survey        = $this->get('Survey');
		$this->pagination    = $this->get('Pagination');
		$this->state         = $this->get('State');
		$this->filterForm    = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
		    throw new Exception(implode('\n', $errors), 500);
		}

		// We don't need toolbar in the modal window.
		if ($this->getLayout() !== 'modal')
		{
			$this->addToolbar();
			
			if(CS_MAJOR_VERSION == 3)
			{
			    $this->sidebar = JHtmlSidebar::render();
			}
		}

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 */
	protected function addToolbar()
	{
		$canDo = JHelperContent::getActions('com_communitysurveys');
		$user  = JFactory::getUser();

		JToolbarHelper::title(JText::_('COM_COMMUNITYSURVEYS_LANGUAGES_TITLE') . ' (' . CjLibUtils::escape($this->survey->title) . ')', 'stack languages');
		
		JToolbarHelper::addNew('language.add');
		if (($canDo->get('core.edit')) || ($canDo->get('core.edit.own')))
		{
			JToolbarHelper::editList('language.edit');
		}

		if ($canDo->get('core.edit.state'))
		{
			JToolbarHelper::publish('languages.publish', 'JTOOLBAR_PUBLISH', true);
			JToolbarHelper::unpublish('languages.unpublish', 'JTOOLBAR_UNPUBLISH', true);
		}

		if ($this->state->get('filter.published') == -2 && $canDo->get('core.delete'))
		{
		    JToolbarHelper::deleteList('', 'languages.delete', 'JTOOLBAR_EMPTY_TRASH');
		}
		elseif ($canDo->get('core.edit.state'))
		{
		    JToolbarHelper::trash('languages.trash');
		}
		
		if ($user->authorise('core.admin', 'com_communitysurveys'))
		{
			JToolbarHelper::preferences('com_communitysurveys');
		}
	}

	/**
	 * Returns an array of fields the table can be sorted by
	 *
	 * @return  array  Array containing the field name to sort by as the key and display text as value
	 */
	protected function getSortFields()
	{
		return array(
			'a.published'    => JText::_('JSTATUS'),
			'a.item_id'      => JText::_('JGLOBAL_TITLE'),
			'a.item_type'    => JText::_('JAUTHOR'),
			'language'       => JText::_('JGRID_HEADING_LANGUAGE'),
		    'a.created_by'   => JText::_('JAUTHOR'),
			'a.created'      => JText::_('JDATE'),
			'a.id'           => JText::_('JGRID_HEADING_ID')
		);
	}
}
