<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

class CommunitySurveysViewReports extends JViewLegacy
{
	public $items;

	public $pagination;

	public $state;

	public function display($tpl = null)
	{
		$app			= JFactory::getApplication();
		$user           = JFactory::getUser();
		$this->item		= $this->get('Item');
		$this->print	= $app->input->getBool('print');
		$this->state	= $this->get('State');
		$this->params 	= $this->state->get('params');
		$this->layout	= $this->getLayout();
		
		if($this->item->created_by != $user->id && !$user->authorise('core.manage', 'com_communitysurveys.survey.'.$this->item->id))
		{
		    throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		}
		
		switch ($this->getLayout())
		{
			case 'responses':
				$return 				= $this->get('Responses');
				$this->responses		= &$return->responses;
				$this->questions		= &$return->questions;
				$this->pagination 		= &$return->pagination;
				$this->authors			= &$return->authors;
				$this->filterForm		= &$return->filterForm;
				$this->activeFilters	= &$return->activeFilters;
				$this->state			= &$return->state;
				$this->filter_rules     = &$return->filter_rules;

				$canDo = JHelperContent::getActions('com_communitysurveys', 'category', $this->state->get('filter.category_id'));
				if ($canDo->get('core.edit.state'))
				{
				    JToolbarHelper::publish('responses.publish', 'JTOOLBAR_PUBLISH', true);
				    JToolbarHelper::unpublish('responses.unpublish', 'JTOOLBAR_UNPUBLISH', true);
				    JToolbarHelper::archiveList('responses.archive');
				}
				
				if ($this->state->get('filter.published') == -2 && $canDo->get('core.delete'))
				{
				    JToolbarHelper::deleteList('', 'responses.delete', 'JTOOLBAR_EMPTY_TRASH');
				}
				elseif ($canDo->get('core.edit.state'))
				{
				    JToolbarHelper::trash('responses.trash');
				}
				
				$this->state->set('filter.survey_id', $this->item->id);
				break;
				
			case 'response':
				$model      = $this->getModel();
				$rid        = $app->input->getInt('rid', 0);
				$this->rid  = $rid;
				
				$model->setState('response.id', $rid);
				$this->questions = $this->get('Response');
				$this->comment = $model->getResponseComment($this->rid);
				break;
				
			case 'consolidated':
			    $data = $this->get('consolidatedReport');
			    $this->report = $data->questions;
			    $this->filter_rules = $data->filter_rules;
				break;
				
			case 'locations':
				$this->report = $this->get('locationsReport');
				break;
				
			case 'browsers':
				$this->report = $this->get('browsersReport');
				break;
				
			case 'platforms':
				$this->report = $this->get('platformsReport');
				break;
				
			case 'default':
			default:
				$this->item->stats = $this->get('Stats');
				$this->layout = 'dashboard';
				break;
		}
		
		if ($this->getLayout() !== 'modal')
		{
			CommunitySurveysHelper::addSubmenu('surveys');
		}
		
		if($this->print)
		{
		    $app->input->set('tmpl', 'component');
		    $app->input->set('format', 'raw');
		    JFactory::getDocument()->setMetaData('robots', 'noindex, nofollow');
		}
		else if($this->getLayout() !== 'modal')
		{
			$this->addToolbar();
			
			if(CS_MAJOR_VERSION == 3)
			{
			    $this->sidebar = JHtmlSidebar::render();
			}
		}
		
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 */
	protected function addToolbar()
	{
		$user  = JFactory::getUser();
		JToolbarHelper::title(JText::_('COM_COMMUNITYSURVEYS_REPORTS_TITLE'), 'stack survey');
		
		switch ($this->getLayout())
		{
		    case 'response':
		        JToolbarHelper::cancel('response.cancel');
		        break;
		        
		    case 'default':
		        JToolbarHelper::cancel('surveys.cancel');
		        break;

		    default:
		        JToolbarHelper::cancel('survey.cancel');
		        break;
		}
		
		if ($user->authorise('core.admin', 'com_communitysurveys'))
		{
			JToolbarHelper::preferences('com_communitysurveys');
		}
	}

	protected function getSortFields()
	{
		return array(
			'a.ordering'     => JText::_('JGRID_HEADING_ORDERING'),
			'a.published'    => JText::_('JSTATUS'),
			'a.title'        => JText::_('JGLOBAL_TITLE'),
			'category_title' => JText::_('JCATEGORY'),
			'access_level'   => JText::_('JGRID_HEADING_ACCESS'),
			'a.created_by'   => JText::_('JAUTHOR'),
			'language'       => JText::_('JGRID_HEADING_LANGUAGE'),
			'a.created'      => JText::_('JDATE'),
			'a.id'           => JText::_('JGRID_HEADING_ID'),
			't.ip_address'		=> JText::_('COM_COMMUNITYSURVEYS_IP_ADDRESS'),
			't.country'			=> JText::_('COM_COMMUNITYSURVEYS_COUNTRY'),
			't.city'			=> JText::_('COM_COMMUNITYSURVEYS_CITY'),
			't.browser_name'	=> JText::_('COM_COMMUNITYSURVEYS_BROWSER'),
			't.os'				=> JText::_('COM_COMMUNITYSURVEYS_OS')
		);
	}
}