<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

$user		= JFactory::getUser();
$userId		= $user->get('id');
$archived	= $this->state->get('filter.published') == 2 ? true : false;
$trashed	= $this->state->get('filter.published') == -2 ? true : false;
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$span 		= !empty( $this->sidebar) ? 'col-md-10' : 'col-md-12';
$surveyId 	= $this->state->get('filter.survey_id', 0);
$return     = base64_encode(JUri::getInstance());
?>
<script type="text/javascript">
	Joomla.orderTable = function()
	{
		table = document.getElementById("sortTable");
		direction = document.getElementById("directionTable");
		order = table.options[table.selectedIndex].value;
		if (order != '<?php echo $listOrder; ?>')
		{
			dirn = 'asc';
		}
		else
		{
			dirn = direction.options[direction.selectedIndex].value;
		}
		Joomla.tableOrdering(order, dirn, '');
	}
</script>
<div class="row" id="cj-wrapper">
    <?php if (!empty( $this->sidebar)) : ?>
    <div id="j-sidebar-container" class="col-md-2">
    	<?php echo $this->sidebar; ?>
    </div>
    <?php endif;?>
    <div class="<?php echo $span;?>">
    	<div id="j-main-container">
			<form action="<?php echo JRoute::_('index.php?option=com_communitysurveys&view=responses'); ?>" method="post" name="adminForm" id="adminForm">
    			<?php
        		// Search tools bar
        		echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this));
        		?>
        		<?php if (empty($this->items)) : ?>
        			<div class="alert alert-no-items">
        				<?php echo JText::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
        			</div>
        		<?php else : ?>
        			<table class="table table-striped" id="responsesList">
        				<thead>
        					<tr>
        						<th width="1%" class="hidden-phone">
        							<?php echo JHtml::_('grid.checkall'); ?>
        						</th>
        						<th width="1%" style="min-width:55px" class="nowrap center">
        							<?php echo JHtml::_('searchtools.sort', 'JSTATUS', 'a.published', $listDirn, $listOrder); ?>
        						</th>
        						<?php if(!$surveyId):?>
        						<th>
        							<?php echo JHtml::_('searchtools.sort', 'JGLOBAL_TITLE', 'a.title', $listDirn, $listOrder); ?>
        						</th>
        						<?php endif;?>
        						<th>
        							<?php echo JHtml::_('searchtools.sort',  'JAUTHOR', 'a.created_by', $listDirn, $listOrder); ?>
        						</th>
        						<th width="10%" class="nowrap hidden-phone">
        							<?php echo JHtml::_('searchtools.sort', 'JDATE', 'a.created', $listDirn, $listOrder); ?>
        						</th>
        						<?php if($user->authorise('core.admin', 'com_communitysurveys')):?>
        						<th width="10%" class="nowrap hidden-phone">
        							<?php echo JHtml::_('searchtools.sort', 'COM_COMMUNITYSURVEYS_IP_ADDRESS', 't.ip_address', $listDirn, $listOrder); ?>
        						</th>
        						<?php endif;?>
        						<th width="10%" class="nowrap hidden-phone">
        							<?php echo JHtml::_('searchtools.sort', 'COM_COMMUNITYSURVEYS_COUNTRY', 't.country', $listDirn, $listOrder); ?>
        						</th>
        						<th width="10%" class="nowrap hidden-phone">
        							<?php echo JHtml::_('searchtools.sort', 'COM_COMMUNITYSURVEYS_CITY', 't.city', $listDirn, $listOrder); ?>
        						</th>
        						<th width="10%" class="nowrap hidden-phone">
        							<?php echo JHtml::_('searchtools.sort', 'COM_COMMUNITYSURVEYS_BROWSER', 't.browser_name', $listDirn, $listOrder); ?>
        						</th>
        						<th width="10%" class="nowrap hidden-phone">
        							<?php echo JHtml::_('searchtools.sort', 'COM_COMMUNITYSURVEYS_OS', 't.os', $listDirn, $listOrder); ?>
        						</th>
        						<th width="1%" class="nowrap hidden-phone">
        							<?php echo JHtml::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
        						</th>
        					</tr>
        				</thead>
        				<tbody>
        				<?php foreach ($this->items as $i => $item) :
        					$canCheckin = $user->authorise('core.manage',     'com_checkin') || $item->checked_out == $userId || $item->checked_out == 0;
        					$canChange  = $user->authorise('core.edit.state', 'com_communitysurveys.survey.'.$item->id) && $canCheckin;
        					$canEdit    = $user->authorise('core.edit',       'com_communitysurveys.survey.'.$item->id);
        					$canEditOwn = $user->authorise('core.edit.own',   'com_communitysurveys.survey.'.$item->id) && $item->created_by == $userId;
        					?>
        					<tr class="row<?php echo $i % 2; ?>">
        						<td class="center hidden-phone">
        							<?php echo JHtml::_('grid.id', $i, $item->id); ?>
        						</td>
        						<td class="center">
        							<div class="btn-group">
        								<?php echo JHtml::_('jgrid.published', $item->state, $i, 'responses.', $canChange, 'cb'); ?>
        								<?php
        								// Create dropdown items
        								$action = $archived ? 'unarchive' : 'archive';
        								JHtml::_('actionsdropdown.' . $action, 'cb' . $i, 'responses');
        
        								$action = $trashed ? 'untrash' : 'trash';
        								JHtml::_('actionsdropdown.' . $action, 'cb' . $i, 'responses');
        
        								// Render dropdown list
        								echo JHtml::_('actionsdropdown.render', $this->escape($item->title));
        								?>
        							</div>
        						</td>
        						<td class="has-context">
        							<div class="pull-left">
        								<?php if ($item->language == '*'):?>
        									<?php $language = JText::alt('JALL', 'language'); ?>
        								<?php else:?>
        									<?php $language = !empty($item->language_title) ? $this->escape($item->language_title) : JText::_('JUNDEFINED'); ?>
        								<?php endif;?>
        								
        								<?php if ($canEdit || $canEditOwn) : ?>
        									<a href="<?php echo JRoute::_('index.php?option=com_communitysurveys&view=reports&layout=response&id='.$item->survey_id.'&rid='.$item->id); ?>" 
        										title="<?php echo JText::_('JACTION_EDIT'); ?>">
        										<?php echo $this->escape($item->title); ?>
        									</a>
        								<?php else : ?>
        									<span title="<?php echo JText::sprintf('JFIELD_ALIAS_LABEL', $this->escape($item->alias)); ?>"><?php echo $this->escape($item->title); ?></span>
        								<?php endif; ?>
        							</div>
        						</td>						
        						<td>
        							<?php if($item->created_by > 0):?>
        							<a href="<?php echo JRoute::_('index.php?option=com_users&task=user.edit&id='.(int) $item->created_by); ?>" title="<?php echo JText::_('JAUTHOR'); ?>">
        								<?php echo $this->escape($item->author_name); ?>
        							</a>
        							<?php else :?>
        								<?php echo JText::_('COM_COMMUNITYSURVEYS_GUEST');?>
        							<?php endif;?>
        						</td>
        						<td class="nowrap small hidden-phone">
        							<?php echo JHtml::_('date', $item->created, JText::_('DATE_FORMAT_LC4')); ?>
        						</td>
        						<?php if($user->authorise('core.admin', 'com_communitysurveys')):?>
        						<td>
        							<?php echo $item->ip_address;?>
        						</td>
        						<?php endif;?>
        						<td>
        							<?php echo $item->country_name;?>
        						</td>
        						<td>
        							<?php echo $item->city;?>
        						</td>
        						<td>
        							<?php echo $item->browser_name;?>
        						</td>
        						<td>
        							<?php echo $item->os;?>
        						</td>
        						<td class="center hidden-phone">
        							<?php echo (int) $item->id; ?>
        						</td>
        					</tr>
        					<?php endforeach; ?>
        				</tbody>
        			</table>
        		<?php endif; ?>
        		<?php echo $this->pagination->getListFooter(); ?>
        		<?php //Load the batch processing form. ?>
        		<?php //echo $this->loadTemplate('batch'); ?>
        
        		<input type="hidden" name="task" value="" />
        		<input type="hidden" name="survey_id" value="<?php echo $surveyId;?>" />
        		<input type="hidden" name="boxchecked" value="0" />
        		<input type="hidden" name="return" value="<?php echo $return;?>" />
        		<?php echo JHtml::_('form.token'); ?>
			</form>
		</div>
	</div>
</div>
