<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');

JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

$app		= JFactory::getApplication();
$user		= JFactory::getUser();
$userId		= $user->get('id');
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$archived	= $this->state->get('filter.published') == 2 ? true : false;
$trashed	= $this->state->get('filter.published') == -2 ? true : false;
$saveOrder	= $listOrder == 'a.ordering';
$anonymous	= $this->state->params->get('anonymous', 0);

if ($saveOrder)
{
	$saveOrderingUrl = 'index.php?option=com_communitysurveys&task=surveys.saveOrderAjax&tmpl=component';
	JHtml::_('sortablelist.sortable', 'surveyList', 'adminForm', strtolower($listDirn), $saveOrderingUrl);
}

$sortFields = $this->getSortFields();
$assoc		= false;//JLanguageAssociations::isEnabled();
$span 		= !empty( $this->sidebar) ? 'col-md-10' : 'col-md-12';
?>
<script type="text/javascript">
	Joomla.orderTable = function()
	{
		table = document.getElementById("sortTable");
		direction = document.getElementById("directionTable");
		order = table.options[table.selectedIndex].value;
		if (order != '<?php echo $listOrder; ?>')
		{
			dirn = 'asc';
		}
		else
		{
			dirn = direction.options[direction.selectedIndex].value;
		}
		Joomla.tableOrdering(order, dirn, '');
	}

	Joomla.submitbutton = function(pressbutton)
	{
		if(pressbutton == 'import.save')
		{
			jQuery('form[name="importForm"]').toggle('slow');
		}
		else
		{
			Joomla.submitform(pressbutton);
		}
	}
</script>

<div class="row" id="cj-wrapper">
    <?php if (!empty( $this->sidebar)) : ?>
    <div id="j-sidebar-container" class="col-md-2">
    	<?php echo $this->sidebar; ?>
    </div>
    <?php endif;?>
    <div class="<?php echo $span;?>">
    	<div id="j-main-container">
            <form name="importForm" method="post" action="<?php echo JRoute::_('index.php?option=com_communitysurveys&task=import.save')?>" enctype="multipart/form-data" style="display: none;">
                <div class="well well-small">
                    <p><?php echo JText::_('COM_COMMUNITYSURVEYS_SELECT_FILE_TO_IMPORT');?></p>
                    <input name="xmlfile" type="file"> <input type="submit" value="<?php echo JText::_('JSUBMIT');?>">
                </div>
            </form>
            <form action="<?php echo JRoute::_('index.php?option=com_communitysurveys&view=surveys'); ?>" method="post" name="adminForm" id="adminForm">
        		<?php
        		// Search tools bar
        		echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this));
        		?>
        		<?php if (empty($this->items)) : ?>
        			<div class="alert alert-no-items">
        				<?php echo JText::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
        			</div>
        		<?php else : ?>
        			<table class="table table-striped" id="surveyList">
        				<thead>
        					<tr>
        						<th width="1%" class="nowrap center hidden-phone">
        							<?php echo JHtml::_('searchtools.sort', '', 'a.ordering', $listDirn, $listOrder, null, 'asc', 'JGRID_HEADING_ORDERING', 'icon-menu-2'); ?>
        						</th>
        						<th width="1%" class="hidden-phone">
        							<?php echo JHtml::_('grid.checkall'); ?>
        						</th>
        						<th width="1%" style="min-width:55px" class="nowrap center">
        							<?php echo JHtml::_('searchtools.sort', 'JSTATUS', 'a.published', $listDirn, $listOrder); ?>
        						</th>
        						<th>
        							<?php echo JHtml::_('searchtools.sort', 'JGLOBAL_TITLE', 'a.title', $listDirn, $listOrder); ?>
        						</th>
        						<th align="center">
        							<?php echo JHtml::_('searchtools.sort', 'COM_COMMUNITYSURVEYS_PRIVATE', 'a.private', $listDirn, $listOrder); ?>
        						</th>
        						<th align="center">
        							<?php echo JText::_('COM_COMMUNITYSURVEYS_ANONYMOUS');?>
        						</th>
        						<th class="nowrap hidden-phone hidden-xs">
        							<?php echo JHtml::_('searchtools.sort',  'JGRID_HEADING_ACCESS', 'a.access', $listDirn, $listOrder); ?>
        						</th>
        					<?php if ($assoc) : ?>
        						<th class="nowrap hidden-phone hidden-xs">
        							<?php echo JHtml::_('searchtools.sort', 'COM_COMMUNITYSURVEYS_HEADING_ASSOCIATION', 'association', $listDirn, $listOrder); ?>
        						</th>
        					<?php endif;?>
        						<th class="nowrap hidden-phone hidden-xs">
        							<?php echo JHtml::_('searchtools.sort',  'JAUTHOR', 'a.created_by', $listDirn, $listOrder); ?>
        						</th>
        						<th class="nowrap hidden-phone hidden-xs">
        							<?php echo JHtml::_('searchtools.sort', 'JGRID_HEADING_LANGUAGE', 'language', $listDirn, $listOrder); ?>
        						</th>
        						<th class="nowrap hidden-phone hidden-xs">
        							<?php echo JHtml::_('searchtools.sort', 'JDATE', 'a.created', $listDirn, $listOrder); ?>
        						</th>
        						<th class="nowrap hidden-phone hidden-xs">
        							<?php echo JHtml::_('searchtools.sort', 'COM_COMMUNITYSURVEYS_LABEL_EXPIRES_ON', 'a.publish_down', $listDirn, $listOrder); ?>
        						</th>
        						<th>
        							<?php echo JHtml::_('searchtools.sort', 'JGLOBAL_HITS', 'a.responses', $listDirn, $listOrder); ?>
        						</th>
        						<th class="nowrap hidden-phone hidden-xs">
        							<?php echo JHtml::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
        						</th>
        					</tr>
        				</thead>
        				<tbody>
        				<?php foreach ($this->items as $i => $item) :
        					$item->max_ordering = 0; //??
        					$ordering   = ($listOrder == 'a.ordering');
        					$canCreate  = $user->authorise('core.create',     'com_communitysurveys.category.'.$item->catid);
        					$canEdit    = $user->authorise('core.edit',       'com_communitysurveys.survey.'.$item->id);
        					$canCheckin = $user->authorise('core.manage',     'com_checkin') || $item->checked_out == $userId || $item->checked_out == 0;
        					$canEditOwn = $user->authorise('core.edit.own',   'com_communitysurveys.survey.'.$item->id) && $item->created_by == $userId;
        					$canChange  = $user->authorise('core.edit.state', 'com_communitysurveys.survey.'.$item->id) && $canCheckin;
        					?>
        					<tr class="row<?php echo $i % 2; ?>" sortable-group-id="<?php echo $item->catid; ?>">
        						<td class="order nowrap center hidden-phone">
        							<?php
        							$iconClass = '';
        							if (!$canChange)
        							{
        								$iconClass = ' inactive';
        							}
        							elseif (!$saveOrder)
        							{
        								$iconClass = ' inactive tip-top hasTooltip" title="' . JHtml::tooltipText('JORDERINGDISABLED');
        							}
        							?>
        							<span class="sortable-handler<?php echo $iconClass ?>">
        								<i class="icon-menu"></i>
        							</span>
        							<?php if ($canChange && $saveOrder) : ?>
        								<input type="text" style="display:none" name="order[]" size="5" value="<?php echo $item->ordering; ?>" class="width-20 text-area-order " />
        							<?php endif; ?>
        						</td>
        						<td class="center hidden-phone">
        							<?php echo JHtml::_('grid.id', $i, $item->id); ?>
        						</td>
        						<td class="center">
        							<div class="btn-group">
        								<?php echo JHtml::_('jgrid.published', $item->published, $i, 'surveys.', $canChange, 'cb', $item->publish_up, $item->publish_down); ?>
        								<?php
        								// Create dropdown items
        								$action = $archived ? 'unarchive' : 'archive';
        								JHtml::_('actionsdropdown.' . $action, 'cb' . $i, 'surveys');
        
        								$action = $trashed ? 'untrash' : 'trash';
        								JHtml::_('actionsdropdown.' . $action, 'cb' . $i, 'surveys');
        
        								// Render dropdown list
        								echo JHtml::_('actionsdropdown.render', $this->escape($item->title));
        								?>
        							</div>
        						</td>
        						<td class="has-context">
        							<div class="pull-left">
        								<?php if ($item->checked_out) : ?>
        									<?php echo JHtml::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'surveys.', $canCheckin); ?>
        								<?php endif; ?>
        								
        								<?php if ($item->language == '*'):?>
        									<?php $language = JText::alt('JALL', 'language'); ?>
        								<?php else:?>
        									<?php $language = $item->language_title ? $this->escape($item->language_title) : JText::_('JUNDEFINED'); ?>
        								<?php endif;?>
        								
        								<?php if ($canEdit || $canEditOwn) : ?>
        									<a href="<?php echo JRoute::_('index.php?option=com_communitysurveys&task=survey.edit&id=' . $item->id); ?>" title="<?php echo JText::_('JACTION_EDIT'); ?>">
        										<?php echo $this->escape($item->title); ?>
        									</a>
        								<?php else : ?>
        									<span title="<?php echo JText::sprintf('JFIELD_ALIAS_LABEL', $this->escape($item->alias)); ?>"><?php echo $this->escape($item->title); ?></span>
        								<?php endif; ?>
        								
        								<span class="small"><?php echo JText::sprintf('JGLOBAL_LIST_ALIAS', $this->escape($item->alias)); ?></span>
        								<div class="small">
        									<?php echo JText::_('JCATEGORY') . ": " . $this->escape($item->category_title); ?>
        								</div>
        								<div class="margin-top-10">
        									<ul class="unstyled list-unstyled inline list-inline no-margin-bottom">
        										<?php if ($canEdit || $canEditOwn) : ?>
        										<li>
                        							<a href="<?php echo JRoute::_('index.php?option=com_communitysurveys&view=survey&layout=questions&id='.$item->id);?>" 
                        								title="<?php echo JText::_('COM_COMMUNITYSURVEYS_EDIT_QUESTIONS')?>" data-toggle="tooltip">
                        								<i class="fa fa-pencil-square"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_EDIT_QUESTIONS');?>
                        							</a>
                        						</li>
                        						<?php endif;?>
                        						<li>
                        							<a href="<?php echo JRoute::_('index.php?option=com_communitysurveys&view=invite&id='.$item->id);?>" 
                        								title="<?php echo JText::_('COM_COMMUNITYSURVEYS_INVITE')?>" data-toggle="tooltip">
                        								<i class="fa fa-envelope"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_INVITE')?>
                        							</a>
                        						</li>
                        						<li>
                        							<a href="<?php echo JRoute::_('index.php?option=com_communitysurveys&view=reports&id='.$item->id);?>" 
                        								title="<?php echo JText::_('COM_COMMUNITYSURVEYS_VIEW_REPORTS')?>" data-toggle="tooltip">
                        								<i class="fa fa-bar-chart"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_REPORTS');?>
                        							</a>
                        						</li>
                        						<li class="no-space-left">
                        							<a href="<?php echo JRoute::_('index.php?option=com_communitysurveys&view=languages&survey_id='.$item->id);?>" 
                        								title="<?php echo JText::_('COM_COMMUNITYSURVEYS_MENU_TRANSLATIONS')?>" data-toggle="tooltip">
                        								<i class="fa fa-globe"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_MENU_TRANSLATIONS')?>
                        							</a>
                        						</li>
                							</ul>
        								</div>
        							</div>
        						</td>
        						<td class="small text-center center hidden-phone hidden-xs">
        							<?php if($item->private == 1): ?>
        							<i class="fa fa-check-square fa-lg"></i>
        							<?php else :?>
        							<i class="fa fa-square-o fa-lg"></i>
        							<?php endif;?>
        						</td>
        						<td class="small text-center center hidden-phone hidden-xs">
        							<?php if($item->params->get('anonymous', $anonymous) == 1): ?>
        							<i class="fa fa-check-square fa-lg"></i>
        							<?php else :?>
        							<i class="fa fa-square-o fa-lg"></i>
        							<?php endif;?>
        						</td>
        						<td class="small hidden-phone hidden-xs">
        							<?php echo $this->escape($item->access_level); ?>
        						</td>
        						<?php if ($assoc) : ?>
        						<td class="hidden-phone hidden-xs">
        							<?php if ($item->association) : ?>
        								<?php echo JHtml::_('contentadministrator.association', $item->id); ?>
        							<?php endif; ?>
        						</td>
        						<?php endif;?>
        						<td class="small hidden-phone hidden-xs">
        							<a href="<?php echo JRoute::_('index.php?option=com_users&task=user.edit&id='.(int) $item->created_by); ?>" title="<?php echo JText::_('JAUTHOR'); ?>">
        								<?php echo $this->escape($item->author_name); ?>
        							</a>
        						</td>
        						<td class="small hidden-phone hidden-xs">
        							<?php if ($item->language == '*'):?>
        								<?php echo JText::alt('JALL', 'language'); ?>
        							<?php else:?>
        								<?php echo $item->language_title ? $this->escape($item->language_title) : JText::_('JUNDEFINED'); ?>
        							<?php endif;?>
        						</td>
        						<td class="nowrap small hidden-phone hidden-xs">
        							<?php echo JHtml::_('date', $item->created, JText::_('DATE_FORMAT_LC4')); ?>
        						</td>
        						<td>
        							<?php 
        							if($item->publish_down && $item->publish_down != '0000-00-00 00:00:00')
        							{
        							    echo JHtml::_('date', $item->publish_down, 'd F Y H:ia');
        							}
        							else
        							{
        							    echo JText::_('COM_COMMUNITYSURVEYS_NEVER');
        							}
        							?>
        						</td>
        						<td class="center">
        							<?php echo (int) $item->responses; ?>
        						</td>
        						<td class="center hidden-phone hidden-xs">
        							<?php echo (int) $item->id; ?>
        						</td>
        					</tr>
        					<?php endforeach; ?>
        				</tbody>
        			</table>
        		<?php endif; ?>
        		
        		<?php 
        		echo $this->pagination->getListFooter(); 
        		//Load the batch processing form.
        		if ($user->authorise('core.create', 'com_communitysurveys') && $user->authorise('core.edit', 'com_communitysurveys') && $user->authorise('core.edit.state', 'com_communitysurveys'))
        		{
        		    echo Jhtml::_('bootstrap.renderModal', 'collapseModal',
        		        array('title'  => JText::_('COM_COMMUNITYSURVEYS_BATCH_OPTIONS'), 'footer' => $this->loadTemplate('batch_footer')),
        		        $this->loadTemplate('batch_body'));
        		}
        		?>
        
        		<input type="hidden" name="task" value="" />
        		<input type="hidden" name="boxchecked" value="0" />
        		<?php echo JHtml::_('form.token'); ?>
            </form>
       </div>
    </div>
</div>