<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

class com_communitysurveysInstallerScript
{
	function install($parent)
	{
	    $this->update($parent);
	    
		$parent->getParent()->setRedirectURL('index.php?option=com_communitysurveys&view=dashboard');
	}

	function uninstall($parent)
	{
		echo '<p>' . JText::_('COM_COMMUNITYSURVEYS_UNINSTALL_TEXT') . '</p>';
	}

	function update($parent)
	{
		$db = JFactory::getDbo();
		
		if(method_exists($parent, 'extension_root')) 
		{
			$sqlfile = $parent->getPath('extension_root').'/sql/install.mysql.utf8.sql';
		} 
		else 
		{
			$sqlfile = $parent->getParent()->getPath('extension_root').'/sql/install.mysql.utf8.sql';
		}
		
		// Don't modify below this line
		$buffer = file_get_contents($sqlfile);
		
		if ($buffer !== false) 
		{
			jimport('joomla.installer.helper');
			$queries = $db->splitSql($buffer);
			
			if (count($queries) != 0) 
			{
				foreach ($queries as $query)
				{
					$query = trim($query);
					
					if ($query != '' && $query{0} != '#') 
					{
						$db->setQuery($query);
						
						try
						{
							$db->execute();
						}
						catch (Exception $e)
						{
// 							JError::raiseWarning(1, JText::sprintf('JLIB_INSTALLER_ERROR_SQL_ERROR', $db->stderr(true)));
// 							return false;
						}
					}
				}
			}
		}
		
		echo '<p>' . JText::_('COM_COMMUNITYSURVEYS_UPDATE_TEXT') . '</p>';
		$parent->getParent()->setRedirectURL('index.php?option=com_communitysurveys&view=dashboard');
	}

	function preflight($type, $parent){
		
		echo '<p>' . JText::_('COM_COMMUNITYSURVEYS_PREFLIGHT_' . $type . '_TEXT') . '</p>';
	}

	function postflight($type, $parent){

		$db = JFactory::getDbo();
		$update_queries = array ();
		require_once JPATH_ROOT.'/components/com_communitysurveys/helpers/constants.php';
		
		/* Old changes */
// 		$update_queries[] = 'ALTER TABLE #__survey ADD COLUMN `catid` int(10) unsigned NOT NULL DEFAULT \'0\'';
// 		$update_queries[] = 'ALTER TABLE #__survey ADD COLUMN `skip_intro` tinyint(1) unsigned NOT NULL DEFAULT \'0\'';
// 		$update_queries[] = 'ALTER TABLE #__survey ADD COLUMN `ip_address` varchar(39) DEFAULT NULL';
// 		$update_queries[] = 'ALTER TABLE #__survey ADD COLUMN `backward_navigation` tinyint(1) unsigned NOT NULL DEFAULT \'1\'';
// 		$update_queries[] = 'ALTER TABLE #__survey ADD COLUMN `display_notice` TINYINT(1) UNSIGNED NOT NULL DEFAULT 1';
// 		$update_queries[] = 'ALTER TABLE #__survey ADD COLUMN `display_progress` TINYINT(1) UNSIGNED NOT NULL DEFAULT 1';
// 		$update_queries[] = 'ALTER TABLE #__survey ADD COLUMN `notification` TINYINT(1) UNSIGNED NOT NULL DEFAULT 1';
// 		$update_queries[] = 'ALTER TABLE #__survey ADD COLUMN `restriction` VARCHAR(32) NOT NULL DEFAULT \'cookie\'';
// 		$update_queries[] = 'ALTER TABLE #__survey ADD COLUMN `enable_save_btn` TINYINT(1) NOT NULL DEFAULT 1';
// 		$update_queries[] = 'ALTER TABLE #__survey ADD COLUMN `language` CHAR(7) NOT NULL DEFAULT \'*\'';
// 		$update_queries[] = 'ALTER TABLE #__survey ADD INDEX `idx_survey_published` (`published` ASC)';
// 		$update_queries[] = 'ALTER TABLE #__survey ADD INDEX `idx_survey_catid` (`catid` ASC)';
// 		$update_queries[] = 'ALTER TABLE #__survey ADD INDEX `idx_survey_created_by` (`created_by` ASC)';
		$update_queries[] = 'ALTER TABLE #__survey_keys ADD COLUMN `created` DATETIME NOT NULL DEFAULT \'0000-00-00 00:00:00\'';
		$update_queries[] = 'ALTER TABLE #__survey_keys ADD COLUMN `contact_id` INTEGER UNSIGNED NOT NULL DEFAULT 0';
		$update_queries[] = 'ALTER TABLE #__survey_keys ADD COLUMN `user_id` INT(10) NOT NULL DEFAULT 0';
		$update_queries[] = 'ALTER TABLE #__survey_keys ADD INDEX `idx_survey_keys_survey_id` (`survey_id` ASC)';
		$update_queries[] = 'ALTER TABLE #__survey_keys ADD INDEX `idx_survey_keys_response_id` (`response_id` ASC)';
		$update_queries[] = 'ALTER TABLE #__survey_answers ADD COLUMN `image` varchar(40) DEFAULT NULL';
		$update_queries[] = 'ALTER TABLE #__survey_contacts ADD UNIQUE INDEX `idx_uniq_survey_contacts_email`(`email`, `created_by`)';
		$update_queries[] = 'ALTER TABLE #__survey_questions ADD COLUMN `min_selections` int(3) UNSIGNED NOT NULL DEFAULT 0';
		$update_queries[] = 'ALTER TABLE #__survey_questions ADD COLUMN `max_selections` int(3) UNSIGNED NOT NULL DEFAULT 0';
		$update_queries[] = 'ALTER TABLE #__survey_questions ADD COLUMN `params` TEXT';
		$update_queries[] = 'ALTER TABLE #__survey_pages ADD INDEX `idx_survey_pages_sort_order` (`sort_order` ASC)';
		$update_queries[] = 'ALTER TABLE #__survey_pages ADD INDEX `idx_survey_sid` (`sid` ASC)';
		$update_queries[] = 'UPDATE #__survey_answers set image = null where image = \'undefined\'';
		
        // for v4
        $update_queries[] = 'ALTER TABLE `#__survey_pages` ADD COLUMN `title` VARCHAR(256)';
        $update_queries[] = 'ALTER TABLE `#__survey_questions` MODIFY COLUMN `orientation` VARCHAR(2) NOT NULL DEFAULT \'RW\'';
        $update_queries[] = 'ALTER TABLE `#__survey_responses` ADD COLUMN `state` TINYINT(3) NOT NULL DEFAULT 1';
        $update_queries[] = 'ALTER TABLE `#__survey_response_details` ADD COLUMN `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT FIRST, ADD PRIMARY KEY (`id`)';
        $update_queries[] = 'ALTER TABLE `#__survey_responses` ADD COLUMN `curr_page` INT(10) UNSIGNED NOT NULL DEFAULT \'0\'';
        $update_queries[] = 'ALTER TABLE `#__survey_responses` ADD COLUMN `comment` MEDIUMTEXT NULL';
        $update_queries[] = 'ALTER TABLE `#__survey_response_details` CHANGE COLUMN `free_text` `free_text` MEDIUMTEXT NULL';
        $update_queries[] = 'UPDATE `#__survey_questions` SET orientation = CASE orientation WHEN \'H\' THEN \'RW\' ELSE \'IL\' END WHERE orientation NOT IN(\'RW\', \'IL\')';
        
        $update_queries[] = 'ALTER TABLE `#__survey_surveys` CHANGE COLUMN `asset_id` `asset_id` INT(10) UNSIGNED NOT NULL DEFAULT \'0\'';
        $update_queries[] = 'ALTER TABLE `#__survey_surveys` CHANGE COLUMN `modified` `modified` DATETIME NOT NULL DEFAULT \'0000-00-00 00:00:00\', CHANGE COLUMN `modified_by` `modified_by` INT(10) NOT NULL DEFAULT \'0\'';
        
        // Survey categories migration
        $update_queries[] ='ALTER TABLE `#__survey_categories` ADD COLUMN `migrated` INTEGER UNSIGNED NOT NULL DEFAULT 0';
        $update_queries[] ='ALTER TABLE `#__survey_translations` ADD COLUMN `parent_id` INTEGER UNSIGNED NOT NULL DEFAULT 0';
		
		// Perform all queries - we don't care if it fails
		foreach( $update_queries as $query ) 
		{
			$db->setQuery( $query );
			
			try
			{
				$db->execute();
			}
			catch (Exception $e) 
			{
			}
		}
		
		// add core features support
		$this->add_core_features_support();
		
		// Migrate features
// 		$this->migrate_features();

		/** Create images and cache folders**/
		JFolder::create(JPATH_ROOT.'/media/communitysurveys/images');
		JFolder::create(JPATH_ROOT.'/media/communitysurveys/tmp');
		
		touch(JPATH_ROOT.'/media/communitysurveys/index.html');
		touch(JPATH_ROOT.'/media/communitysurveys/images/index.html');
		touch(JPATH_ROOT.'/media/communitysurveys/tmp/index.html');
		/** end creating folders **/
		
		if(file_exists(JPATH_ROOT.'/components/com_communitysurveys/views/user/view.html.php'))
		{
			JFolder::delete(JPATH_ROOT.'/components/com_communitysurveys/views/user/');
		}
		
		if(file_exists(JPATH_ROOT.'/components/com_communitysurveys/views/response/view.html.php'))
		{
			JFolder::delete(JPATH_ROOT.'/components/com_communitysurveys/views/response/');
		}
		
		echo '<p>' . JText::_('COM_COMMUNITYSURVEYS_POSTFLIGHT_' . $type . '_TEXT') . '</p>';
	}

	private function migrate_features()
	{
		// check if the categories are already upgraded
		if(CS_MAJOR_VERSION < 4)
		{
		    require_once JPATH_ADMINISTRATOR . '/components/com_categories/models/category.php';
		}
	
		jimport('joomla.application.categories');
		$categories = JCategories::getInstance('CommunitySurveys');
	
		if(count($categories->get(0)->getChildren()) == 0)
		{
			// no cateogories upgraded, then get the existing categories
			/****************** CJLib includes ***************************/
			if(file_exists(JPATH_ROOT.'/components/com_cjlib/framework.php'))
			{
				require_once JPATH_ROOT.'/components/com_cjlib/framework.php';
			}
			else
			{
				die('CJLib (CoreJoomla API Library) component not found. Please download and install it to continue.');
			}
			CJLib::import('corejoomla.nestedtree.core');
			/****************** CJLib includes ***************************/
			
			try 
			{
				$db = JFactory::getDbo();
				$tree = new CjNestedTree($db, '#__survey_categories');
				$existing = $tree->get_tree();
		
				if(!empty($existing))
				{
					$this->add_category($existing);
				}
			}
			catch (Exception $e)
			{
				// do nothing as this not the migration
			}
		}
	}
	
	private function add_category($nodes, $path = '', $nlevel = 1, $parent_id = 0)
	{
		foreach($nodes as $node)
		{
			if($node['migrated'] > 0)
			{
				// category already migrated, don't do anything.
			}
			else
			{
				$config = array( 'table_path' => JPATH_ADMINISTRATOR.'/components/com_categories/tables');
				$model = new CategoriesModelCategory( $config );
					
				$data = array(
						'id' => 0,
						'parent_id' => $parent_id,
						'level' => $nlevel,
						'path' => $path.$node['alias'],
						'extension' => 'com_communitysurveys',
						'title' => $node['title'],
						'alias' => $node['alias'],
						'description' => '',
						'published' => 1,
						'language' => $node['language']);
					
				$status = $model->save( $data );
	
				if(!$status)
				{
				    throw new Exception(JText::_('Unable to create default content category!'), 500);
				}
				else
				{
					$newid = $model->getState($model->getName().'.id');
					if($newid)
					{
						try
						{
							$db = JFactory::getDbo();
							$query = $db->getQuery(true)->update('#__survey_categories')->set('migrated = '. $newid)->where('id = '.$node['id']);
							$db->setQuery($query);
							$db->execute();
							
							$query = $db->getQuery(true)->update('#__survey_surveys')->set('catid = '.$newid)->where('catid = '.$node['id']);
							$db->setQuery($query);
							$db->execute();
						}
						catch (Exception $e)
						{
						    throw new Exception(JText::_('Unable to update category data!'), 500);
						}
					}
				}
					
				if(!empty($node['children']))
				{
					$this->add_category($node['children'], $path.'/', $nlevel + 1, $newid);
				}
			}
		}
	}
	
	private function add_core_features_support()
	{
		// add survey content type to content_types table
		$survey_table_def = new stdClass();
		$survey_table_def->special = new stdClass();
		$survey_table_def->special->dbtable = '#__survey_surveys';
		$survey_table_def->special->key = 'id';
		$survey_table_def->special->type = 'Survey';
		$survey_table_def->special->prefix = 'CommunitySurveysTable';
		$survey_table_def->special->config = 'array()';
	
		$survey_table_def->common = new stdClass();
		$survey_table_def->common->dbtable = '#__ucm_content';
		$survey_table_def->common->key = 'ucm_id';
		$survey_table_def->common->type = 'Corecontent';
		$survey_table_def->common->prefix = 'JTable';
		$survey_table_def->common->config ='array()';
	
		$survey_field_mappings = new stdClass();
		$survey_field_mappings->common = new stdClass();
		$survey_field_mappings->common->core_content_item_id = 'id';
		$survey_field_mappings->common->core_title = 'title';
		$survey_field_mappings->common->core_state = 'published';
		$survey_field_mappings->common->core_alias = 'alias';
		$survey_field_mappings->common->core_created_time = 'created';
		$survey_field_mappings->common->core_modified_time = 'modified';
		$survey_field_mappings->common->core_body = 'description';
		$survey_field_mappings->common->core_hits = 'responses';
		$survey_field_mappings->common->core_publish_up = 'publish_up';
		$survey_field_mappings->common->core_publish_down = 'publish_down';
		$survey_field_mappings->common->core_access = 'access';
		$survey_field_mappings->common->core_params= 'params';
		$survey_field_mappings->common->core_featured = 'featured';
		$survey_field_mappings->common->core_metadata = 'metadata';
		$survey_field_mappings->common->core_language = 'language';
		$survey_field_mappings->common->core_ordering = 'ordering';
		$survey_field_mappings->common->core_metakey = 'metakey';
		$survey_field_mappings->common->core_metadesc = 'metadesc';
		$survey_field_mappings->common->core_catid = 'catid';
		$survey_field_mappings->common->core_xreference = 'null';
		$survey_field_mappings->common->core_images = 'null';
		$survey_field_mappings->common->core_urls = 'null';
		
		$survey_field_mappings->special = new stdClass();
		$survey_field_mappings->special->private = 'private';
		$survey_field_mappings->special->survey_key = 'survey_key';
		$survey_field_mappings->special->ip_address = 'ip_address';
	
		$display_lookup_catid = new stdClass();
		$display_lookup_catid->sourceColumn = 'catid';
		$display_lookup_catid->targetTable = '#__categories';
		$display_lookup_catid->targetColumn = 'id';
		$display_lookup_catid->displayColumn = 'title';
	
		$display_lookup_title = new stdClass();
		$display_lookup_title->sourceColumn = 'created_by';
		$display_lookup_title->targetTable = '#__users';
		$display_lookup_title->targetColumn = 'id';
		$display_lookup_title->displayColumn = 'name';
	
		$display_lookup_access = new stdClass();
		$display_lookup_access->sourceColumn = 'access';
		$display_lookup_access->targetTable = '#__viewlevels';
		$display_lookup_access->targetColumn = 'id';
		$display_lookup_access->displayColumn = 'title';
	
		$display_lookup_modified_by = new stdClass();
		$display_lookup_modified_by->sourceColumn = 'modified_by';
		$display_lookup_modified_by->targetTable = '#__users';
		$display_lookup_modified_by->targetColumn = 'id';
		$display_lookup_modified_by->displayColumn = 'name';
	
		$survey_history_options = new stdClass();
		$survey_history_options->formFile = 'administrator/components/com_communitysurveys/models/forms/survey.xml';
		$survey_history_options->hideFields = array('asset_id','checked_out','checked_out_time','version');
		$survey_history_options->ignoreChanges = array('modified_by', 'modified', 'checked_out', 'checked_out_time', 'answers');
		$survey_history_options->convertToInt = array('publish_up', 'publish_down', 'featured', 'ordering');
		$survey_history_options->displayLookup = array($display_lookup_catid, $display_lookup_title, $display_lookup_access, $display_lookup_modified_by);
	
		$survey_table = JTable::getInstance('Contenttype', 'JTable');
		$survey_type_id = (int) $survey_table->getTypeId('com_communitysurveys.survey');
	
		$survey_content_type = array();
		$survey_content_type['type_id'] = $survey_type_id;
		$survey_content_type['type_title'] = 'Survey';
		$survey_content_type['type_alias'] = 'com_communitysurveys.survey';
		$survey_content_type['table'] = json_encode($survey_table_def);
		$survey_content_type['rules'] = '';
		$survey_content_type['router'] = 'CommunitySurveysHelperRoute::getSurveyRoute';
		$survey_content_type['field_mappings'] = json_encode($survey_field_mappings);
		$survey_content_type['content_history_options'] = json_encode($survey_history_options);
	
		$survey_table->save($survey_content_type);
	
		// add survey category type to content_types table
		$category_table_def = new stdClass();
		$category_table_def->special = new stdClass();
		$category_table_def->special->dbtable = '#__categories';
		$category_table_def->special->key = 'id';
		$category_table_def->special->type = 'Category';
		$category_table_def->special->prefix = 'JTable';
		$category_table_def->special->config = 'array()';
	
		$category_table_def->common = new stdClass();
		$category_table_def->common->dbtable = '#__ucm_content';
		$category_table_def->common->key = 'ucm_id';
		$category_table_def->common->type = 'Corecontent';
		$category_table_def->common->prefix = 'JTable';
		$category_table_def->common->config =  'array()';
	
		$category_field_mappings = new stdClass();
		$category_field_mappings->common = new stdClass();
		$category_field_mappings->common->core_content_item_id = 'id';
		$category_field_mappings->common->core_title = 'title';
		$category_field_mappings->common->core_state = 'published';
		$category_field_mappings->common->core_alias = 'alias';
		$category_field_mappings->common->core_created_time = 'created_time';
		$category_field_mappings->common->core_modified_time = 'modified_time';
		$category_field_mappings->common->core_body = 'description';
		$category_field_mappings->common->core_hits = 'hits';
		$category_field_mappings->common->core_publish_up = 'null';
		$category_field_mappings->common->core_publish_down = 'null';
		$category_field_mappings->common->core_access = 'access';
		$category_field_mappings->common->core_params = 'params';
		$category_field_mappings->common->core_featured = 'null';
		$category_field_mappings->common->core_metadata = 'metadata';
		$category_field_mappings->common->core_language = 'language';
		$category_field_mappings->common->core_images = 'null';
		$category_field_mappings->common->core_urls = 'null';
		$category_field_mappings->common->core_version = 'version';
		$category_field_mappings->common->core_ordering = 'null';
		$category_field_mappings->common->core_metakey = 'metakey';
		$category_field_mappings->common->core_metadesc = 'metadesc';
		$category_field_mappings->common->core_catid = 'parent_id';
		$category_field_mappings->common->core_xreference = 'null';
		$category_field_mappings->common->asset_id = 'asset_id';
	
		$category_field_mappings->special = new stdClass();
		$category_field_mappings->special->parent_id = 'parent_id';
		$category_field_mappings->special->lft = 'lft';
		$category_field_mappings->special->rgt = 'rgt';
		$category_field_mappings->special->level = 'level';
		$category_field_mappings->special->path = 'path';
		$category_field_mappings->special->extension = 'extension';
		$category_field_mappings->special->note = 'note';
	
		$category_display_created_by = new stdClass();
		$category_display_created_by->sourceColumn = 'created_user_id';
		$category_display_created_by->targetTable = '#__users';
		$category_display_created_by->targetColumn = 'id';
		$category_display_created_by->displayColumn = 'name';
	
		$category_display_access = new stdClass();
		$category_display_access->sourceColumn = 'access';
		$category_display_access->targetTable = '#__viewlevels';
		$category_display_access->targetColumn = 'id';
		$category_display_access->displayColumn = 'title';
	
		$category_display_modified_by = new stdClass();
		$category_display_modified_by->sourceColumn = 'modified_user_id';
		$category_display_modified_by->targetTable = '#__users';
		$category_display_modified_by->targetColumn = 'id';
		$category_display_modified_by->displayColumn = 'name';
	
		$category_display_parent_id = new stdClass();
		$category_display_parent_id->sourceColumn = 'parent_id';
		$category_display_parent_id->targetTable = '#__categories';
		$category_display_parent_id->targetColumn = 'id';
		$category_display_parent_id->displayColumn = 'title';
	
		$category_history_options = new stdClass();
		$category_history_options->formFile = 'administrator/components/com_categories/models/forms/category.xml';
		$category_history_options->hideFields = array('asset_id','checked_out', 'checked_out_time'. 'version', 'lft', 'rgt', 'level', 'path', 'extension');
		$category_history_options->ignoreChanges = array('modified_user_id', 'modified_time', 'checked_out', 'checked_out_time', 'version', 'hits', 'path');
		$category_history_options->convertToInt = array('publish_up', 'publish_down');
		$category_history_options->displayLookup = array($category_display_created_by, $category_display_access, $category_display_modified_by, $category_display_parent_id);
	
		$category_table = JTable::getInstance('Contenttype', 'JTable');
		$category_type_id = (int) $category_table->getTypeId('com_communitysurveys.category');
	
		$category_content_type = array();
		$category_content_type['type_id'] = $category_type_id;
		$category_content_type['type_title'] = 'Survey Category';
		$category_content_type['type_alias'] = 'com_communitysurveys.category';
		$category_content_type['table'] = json_encode($category_table_def);
		$category_content_type['rules']	= '';
		$category_content_type['router'] = 'CommunitySurveysHelperRoute::getCategoryRoute';
		$category_content_type['field_mappings'] = json_encode($category_field_mappings);
		$category_content_type['content_history_options'] = json_encode($category_history_options);
	
		$category_table->save($category_content_type);
	}
}
