<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

class CommunitySurveysController extends JControllerLegacy
{
	public function __construct ($config = array())
	{
		$this->input = JFactory::getApplication()->input;
		
		// Question frontpage Editor pagebreak proxying:
		if ($this->input->get('view') === 'survey' && $this->input->get('layout') === 'pagebreak')
		{
		    $config['base_path'] = JPATH_COMPONENT_ADMINISTRATOR;
		}
		// Question frontpage Editor survey proxying:
		elseif ($this->input->get('view') === 'surveys' && $this->input->get('layout') === 'modal')
		{
			JHtml::_('stylesheet', 'system/adminlist.css', array(), true);
			$config['base_path'] = JPATH_COMPONENT_ADMINISTRATOR;
		}
		
		parent::__construct($config);
	}

	public function display ($cachable = false, $urlparams = false)
	{
		$document 	= JFactory::getDocument();
		$user 		= JFactory::getUser();
		
		$cachable 	= true;
		$custom_tag = true;
		
		// Set the default view name and format from the Request.
		// Note we are using t_id to avoid collisions with the router and the return page.
		// Frontend is a bit messier than the backend.
		$id 		= $this->input->getInt('s_id');
		$vName 		= $this->input->getCmd('view', 'surveys');
		$layout 	= $this->input->getCmd('layout', null);
		$this->input->set('view', $vName);
		
		if ( $user->get('id') || in_array($vName, array('survey', 'form')))
		{
			$cachable = false;
		}
		
		$safeurlparams = array(
				'catid' => 'INT',
				'id' => 'INT',
				'survey_id' => 'INT',
				's_id' => 'INT',
				'r_id' => 'INT',
				'cid' => 'ARRAY',
				'year' => 'INT',
				'month' => 'INT',
				'limit' => 'UINT',
				'limitstart' => 'UINT',
				'showall' => 'INT',
				'return' => 'BASE64',
				'filter' => 'STRING',
				'filter_order' => 'CMD',
				'filter_order_Dir' => 'CMD',
				'filter-search' => 'STRING',
				'print' => 'BOOLEAN',
				'lang' => 'CMD',
				'Itemid' => 'INT'
		);
		
		// Check for edit form.
		if ($vName == 'form' && !$layout && ! $this->checkEditId('com_communitysurveys.edit.survey', $id))
		{
			// Somehow the person just went to the form - we don't allow that.
			throw new Exception(JText::sprintf('JLIB_APPLICATION_ERROR_UNHELD_ID', $id), 403);
		}

		if($vName == 'report' && $user->guest)
		{
	        $redirectUrl = base64_encode(JUri::getInstance()->toString());
	        $loginUrl = JRoute::_('index.php?option=com_users&view=login&return='.$redirectUrl, false);
	        $this->setRedirect($loginUrl, JText::_('COM_COMMUNITYSURVEYS_ERROR_LOGIN_TO_EXECUTE'));
	        return;
		}
		
		$params 		= JComponentHelper::getParams('com_communitysurveys');
		$loadCss 		= $params->get('load_bootstrap_css', false);
		$custom_tag 	= $params->get('custom_tag', true);
		$mtime          = filemtime(JPATH_COMPONENT_SITE.'/controller.php');
		
		if(!$custom_tag || method_exists($document, 'addCustomTag'))
		{
			CjLib::behavior('bootstrap', array('loadcss' => $loadCss));
			CjScript::_('fontawesome', array('custom'=>$custom_tag));
			
			if($params->get('ui_layout', 'default') != 'default')
			{
				CjScript::_('bootbox', array('custom'=>$custom_tag, 'bootstrap'=>3));
			}
			else
			{
			    CJLib::behavior('bscore', array('customtag'=>$custom_tag));
			}
			
			if($vName == 'survey')
			{
			    if(CS_MAJOR_VERSION < 4)
			    {
			        JHtml::_('jquery.ui', array('core', 'sortable'));
			    }
			    else
			    {
			        CjScript::_('sortable');
			    }
			    
			    CjScript::_('form', array('custom_tag'=>$custom_tag));
			    CjScript::_('validate', array('custom_tag'=>$custom_tag));
			    CjScript::_('blockui', array('custom_tag'=>$custom_tag));
			    CjScript::_('datetime', array('custom'=>$custom_tag, 'version' => CS_MAJOR_VERSION < 4 ? 3 : 4));
			    CjScript::_('signaturepad', array('custom'=>$custom_tag));
			    CjScript::_('slider', array('custom'=>$custom_tag));
			    
			    if(file_exists(JPATH_ROOT.'/media/com_cjlib/checkbox/checkbox.min.css')) 
			    {
			        CjScript::_('checkbox', array('custom'=>$custom_tag));
			    }
			    else 
			    {
			        CJFunctions::add_css_to_document($document, JUri::root(true).'/media/com_communitysurveys/css/checkbox.css', $custom_tag);
			    }
			    
				CJFunctions::add_script(CJLIB_MEDIA_URI.'/jquery/jquery.plugin.min.js', $custom_tag);
				CJFunctions::add_script(JUri::base(true).'/media/system/js/core.js', $custom_tag);
				CJFunctions::add_script(JUri::base(true).'/media/com_cjlib/jquery/json2.js', $custom_tag);
				CJFunctions::add_script(JUri::base(true).'/media/com_communitysurveys/js/jquery.ui.touch-punch.min.js', $custom_tag);
			}
			
			if($vName == 'form')
			{
			    if(CS_MAJOR_VERSION < 4)
			    {
			        JHtml::_('jquery.ui', array('core', 'sortable'));
			    }
			    else
			    {
			        CjScript::_('sortable');
			    }
			    
				CJFunctions::load_jquery(array('libs'=>array('form', 'validate', 'blockui'), 'custom_tag'=>$custom_tag));
				CJFunctions::add_script(CJLIB_MEDIA_URI.'/jquery/jquery.plugin.min.js', $custom_tag);
			}
			
			if($vName == 'report')
			{
				CJFunctions::load_jquery(array('libs'=>array('form'), 'custom_tag'=>$custom_tag));
				CjScript::_('querybuilder', array('custom'=>$custom_tag));
				CjScript::_('chartjs', array('custom'=>$custom_tag));
			}
			
			if($vName == 'invite')
			{
				CJFunctions::load_jquery(array('libs'=>array('form'), 'custom_tag'=>$custom_tag));
			}
			
			if(version_compare(CJLIB_VER, '2.8.9', '>'))
			{
			    CjScript::_('rating', array('custom' => $custom_tag, 'style' => 'fontawesome-stars-o'));
			}
			else
			{
			    CJFunctions::add_css_to_document($document, JUri::root(true).'/media/com_communitysurveys/css/fontawesome-stars-o.css', $custom_tag);
			    CJFunctions::add_script(JUri::root(true).'/media/com_communitysurveys/js/jquery.barrating.min.js?v='.$mtime, $custom_tag);
			}
			
			CjScript::_('noty', array('custom'=>$custom_tag));
			CjScript::_('datetime', array('custom'=>$custom_tag, 'version' => CS_MAJOR_VERSION < 4 ? 3 : 4));

			CJFunctions::add_css_to_document($document, JUri::root(true).'/media/com_communitysurveys/css/cj.surveys.min.css', $custom_tag);
			CJFunctions::add_script(JUri::root(true).'/media/com_communitysurveys/js/cj.surveys.min.js?v='.$mtime, $custom_tag);
			
			// send messages in queue
			CJFunctions::send_messages_from_queue();
		}
		
		parent::display($cachable, $safeurlparams);
		return $this;
	}
}
?>
