<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class CommunitySurveysControllerResponse extends JControllerLegacy 
{
    function __construct()
	{
	    parent::__construct();
	    $this->registerTask('downloadfile', 'downloadFile');
	}
    
    public function downloadFile()
    {
		$user = JFactory::getUser();
		$app = JFactory::getApplication();
		$qid = $app->input->getInt('qid');
		$rid = $app->input->getInt('rid');
		
		if($user->guest || !$rid || !$qid)
		{
		    throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		}
		
		$model = $this->getModel('Response');
		$download = $model->getAttachmentDetails($rid, $qid);
		
		if( empty($download) || ($download->author_id != $user->id && $download->responder_id != $user->id && !$user->authorise('core.manage', 'com_communitysurveys.category.'.$download->catid)) )
		{
		    throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		}

		header("Content-Type: application/force-download");
		header("Content-Type: application/octet-stream");
		header("Content-Type: application/download");
		header("Content-Disposition: attachment; filename=".$download->filename);
			
		readfile(CS_FILE_UPLOAD_DIR.'/'.$download->filename);
		jexit();
	}
    
	private function handleSurveyResponseError($survey, $return, $ajx = false)
	{
		$msg = null;
		
		if(!empty($survey->error))
		{
			switch ($survey->error)
			{
				case 1: // Survey not found
					$msg = JText::_('COM_COMMUNITYSURVEYS_ERROR_SURVEY_NOT_FOUND');
					break;
				case 2: // Unauthorised to take survey
					$msg = JText::_('COM_COMMUNITYSURVEYS_ERROR_UNAUTHORIZED');
					break;
				case 3: // Survey already taken
					$msg = JText::_('COM_COMMUNITYSURVEYS_ERROR_SURVEY_ALREADY_TAKEN');
					break;
				case 4: // DB error, unable to create response
					$msg = JText::_('COM_COMMUNITYSURVEYS_ERROR_INTERNAL_ERROR');
					break;
			}
		}
		else if(empty($survey) || !$survey->id || !$survey->response_id)
		{
			$msg = JText::_('COM_COMMUNITYSURVEYS_ERROR_UNAUTHORIZED');
		}
		
		if($msg)
		{
			$this->setRedirect($return, $msg);
			return false;
		}
		
		return true;
	}
}
?>
