<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

class CommunitySurveysControllerResponses extends JControllerAdmin
{
	public function __construct($config = array())
	{
		parent::__construct($config);
	}

	/**
	 * Proxy for getModel.
	 *
	 * @param   string	$name	The name of the model.
	 * @param   string	$prefix	The prefix for the PHP class name.
	 *
	 * @return  JModel
	 */
	public function getModel($name = 'Responses', $prefix = 'CommunitySurveysModel', $config = array('ignore_request' => true))
	{
		$model = parent::getModel($name, $prefix, $config);
		return $model;
	}

	/**
	 * Function that allows child controller access to model data
	 * after the item has been deleted.
	 *
	 * @param   JModelLegacy  $model  The data model object.
	 * @param   integer       $ids    The array of ids for items being deleted.
	 *
	 * @return  void
	 */
	protected function postDeleteHook(JModelLegacy $model, $ids = null)
	{
	}
	
	public function delete()
	{
	    parent::delete();
	    $this->setRedirect($this->getReturnPage());
	}

	public function publish()
	{
	    parent::publish();
	    $this->setRedirect($this->getReturnPage());
	}
	
	public function reopen()
	{
		// Check for request forgeries
		JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));
		
		// Get items to publish from the request.
		$cid = JFactory::getApplication()->input->get('cid', array(), 'array');
		if (empty($cid))
		{
			JLog::add(JText::_($this->text_prefix . '_NO_ITEM_SELECTED'), JLog::WARNING, 'jerror');
		}
		else
		{
			// Get the model.
			$model = $this->getModel();
		
			// Make sure the item ids are integers
			$cid = Joomla\Utilities\ArrayHelper::toInteger($cid);
		
			// Publish the items.
			try
			{
				$model->reopen($cid);
				$errors = $model->getErrors();
		
				if ($errors)
				{
					$app = JFactory::getApplication();
					$app->enqueueMessage(JText::plural($this->text_prefix . '_N_ITEMS_FAILED_REOPENING', count($cid)), 'error');
				}
				else
				{
					$ntext = $this->text_prefix . '_N_ITEMS_REOPENED';
				}
		
				$this->setMessage(JText::plural($ntext, count($cid)));
			}
			catch (Exception $e)
			{
				$this->setMessage($e->getMessage(), 'error');
			}
		}
		
		$this->setRedirect($this->getReturnPage());
	}
	
	public function export()
	{
	    $user = JFactory::getUser();
	    if($user->guest)
	    {
	        throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
	    }
	    
	    $model = $this->getModel();
	    $filename = $model->getResponsesExportData($user->id);
	    
	    header("Pragma: public");
	    $now = gmdate("D, d M Y H:i:s");
	    header("Expires: Tue, 03 Jul 2001 06:00:00 GMT");
	    header("Cache-Control: max-age=0, no-cache, must-revalidate, proxy-revalidate");
	    header("Last-Modified: {$now} GMT");
	    header("Content-Description: File Transfer");
	    header("Content-Type: application/force-download");
	    header("Content-type: application/octet-stream");
	    header("Content-Type: application/download");
	    header("Content-Disposition: attachment; filename=data_export_" . date("Y-m-d") . ".zip");
	    header("Content-Transfer-Encoding: binary");
	    header("Content-Length: ".filesize($filename));
	    
	    readfile($filename);
	    
	    jexit();
	}
	
	protected function getReturnPage ()
	{
		$return = $this->input->get('return', null, 'base64');
		if (empty($return) || ! JUri::isInternal(base64_decode($return)))
		{
			return JRoute::_('index.php?option=com_communitysurveys&view=reports&layout=responses', false);
		}
		else
		{
			return base64_decode($return);
		}
	}
}
