<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

use Joomla\Utilities\ArrayHelper;

class CommunitySurveysControllerSurvey extends JControllerForm
{
	protected $view_item = 'form';
	protected $view_list = 'categories';
	protected $urlVar = 's_id';
	protected $text_prefix = 'COM_COMMUNITYSURVEYS_SURVEY';

	public function add ()
	{
		if (! parent::add())
		{
			// Redirect to the return page.
			$this->setRedirect($this->getReturnPage());
		}
	}

	protected function allowAdd ($data = array())
	{
		$user = JFactory::getUser();
		$categoryId = ArrayHelper::getValue($data, 'catid', $this->input->getInt('catid'), 'int');
		$allow = null;
		
		if ($categoryId)
		{
			// If the category has been passed in the data or URL check it.
			$allow = $user->authorise('core.create', 'com_communitysurveys.category.' . $categoryId);
		}
		
		if ($allow === null)
		{
			// In the absense of better information, revert to the component
			// permissions.
			return parent::allowAdd();
		}
		else
		{
			return $allow;
		}
	}

	protected function allowEdit ($data = array(), $key = 'id')
	{
		$recordId = (int) isset($data[$key]) ? $data[$key] : 0;
		$user = JFactory::getUser();
		$asset = 'com_communitysurveys.survey.'.$recordId;
		
		// Check general edit permission first.
		if ($user->authorise('core.edit', $asset))
		{
			return true;
		}
		
		// Fallback on edit.own.
		// First test if the permission is available.
		if ($user->authorise('core.edit.own', $asset))
		{
			// Now test the owner is the user.
			$ownerId = (int) isset($data['created_by']) ? $data['created_by'] : 0;
			if (empty($ownerId) && $recordId)
			{
				// Need to do a lookup from the model.
				$record = $this->getModel()->getItem($recordId);
				if (empty($record))
				{
					return false;
				}
				
				$ownerId = $record->created_by;
			}
			
			// If the owner matches 'me' then do the test.
			if ($ownerId == $user->id)
			{
				return true;
			}
		}
		
		// Since there is no asset tracking, revert to the component permissions.
		return parent::allowEdit($data, $key);
	}

	public function cancel ($key = 's_id')
	{
		parent::cancel($key);
		
		// Redirect to the return page.
		$this->setRedirect($this->getReturnPage());
	}

	public function edit ($key = null, $urlVar = 's_id')
	{
		$result = parent::edit($key, $urlVar);
		
		if (!$result)
		{
			$this->setRedirect($this->getReturnPage());
		}
		
		return $result;
	}

	public function getModel ($name = 'form', $prefix = '', $config = array('ignore_request' => true))
	{
		$model = parent::getModel($name, $prefix, $config);
		
		return $model;
	}

	protected function getRedirectToItemAppend ($recordId = null, $urlVar = 's_id')
	{
		$tmpl     = $this->input->get('tmpl');
		$layout   = $this->input->get('layout', 'edit');
		$itemId   = $this->input->getInt('Itemid');
		$catId    = $this->input->getInt('catid', null, 'get');
		$return   = $this->getReturnPage();
		$append   = '';
		
		// Setup redirect info.
		if ($tmpl)
		{
			$append .= '&tmpl=' . $tmpl;
		}
		
		if ($layout)
		{
		    $append .= '&layout=' . $layout;
		}
		
		if ($recordId)
		{
			$append .= '&' . $urlVar . '=' . $recordId;
		}
		
		if ($itemId)
		{
			$append .= '&Itemid=' . $itemId;
		}
		
		if ($catId)
		{
			$append .= '&catid=' . $catId;
		}
		
		if ($return)
		{
			$append .= '&return=' . base64_encode($return);
		}
		
		return $append;
	}

	protected function getReturnPage ()
	{
		$return = $this->input->get('return', null, 'base64');
		
		if (empty($return) || ! JUri::isInternal(base64_decode($return)))
		{
			return JUri::base();
		}
		else
		{
			return base64_decode($return);
		}
	}

	protected function postSaveHook (JModelLegacy $model, $validData = array())
	{
		$surveyId = $model->getState('form.id');
		$return = base64_encode($this->getReturnPage());
		
		$this->setRedirect(JRoute::_(CommunitySurveysHelperRoute::getFormRoute($surveyId).'&layout=questions&return='.$return, false));
	}
	
	public function save($key = null, $urlVar = 's_id')
	{
		$result = parent::save($key, $urlVar);
	
// 		// If ok, redirect to the return page.
// 		if ($result)
// 		{
// 			$this->setRedirect($this->getReturnPage());
// 		}
	
		return $result;
	}
	
	public function publish()
	{
	    $model 		= $this->getModel('Form', '', array());
	    $recordId 	= $this->input->getInt('id');
	    
	    if(!$recordId)
	    {
	        throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'));
	    }
	    
	    if($model->makeSurveyOnline($recordId))
	    {
	    	$model->checkin($recordId);
	        $this->setRedirect(JRoute::_('index.php?option=com_communitysurveys&view=surveys', false), $model->getMessage());
	    }
	    else
	    {
	        $this->setRedirect(JRoute::_('index.php?option=com_communitysurveys&view=surveys', false), $model->getError(), 'error');
	    }
	}
}