<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class CommunitySurveysControllerSurveys extends JControllerAdmin
{
	protected $text_prefix = 'COM_COMMUNITYSURVEYS';
	
	public function __construct($config = array())
	{
		parent::__construct($config);
	}

	public function getModel($name = 'Form', $prefix = 'CommunitySurveysModel', $config = array('ignore_request' => true))
	{
		$model = parent::getModel($name, $prefix, $config);

		return $model;
	}

	protected function getReturnPage ()
	{
		$return = $this->input->get('return', null, 'base64');
		
		if (empty($return) || ! JUri::isInternal(base64_decode($return)))
		{
			$app = JFactory::getApplication();
			$catid = $app->input->post->getInt('jform[catid]');
			
			if($catid)
			{
				return JRoute::_(CommunitySurveysHelperRoute::getCategoryRoute($catid));
			}
			else 
			{
				return JRoute::_('index.php?option=com_communitysurveys&view=categories&id=0');
			}
		}
		else
		{
			return base64_decode($return);
		}
	}
}
