<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class SurveyHelper
{
	protected static $_countries = null;
	private static $_router = null;
	
	public static function getQuestionIcon($type)
	{
	    switch ($type)
	    {
	        case CS_PAGE_HEADER:
	            return 'fa fa-magnet';
	
	        case CS_CHOICE_RADIO:
	            return 'fa fa-dot-circle-o';
	
	        case CS_CHOICE_CHECKBOX;
	        return 'fa fa-check-circle-o';
	
	        case CS_CHOICE_SELECT:
	            return 'fa fa-hand-o-up';
	            
	        case CS_CHOICE_MULTIRATING:
	        	return 'fa fa-star';
	        	
	        case CS_CHOICE_RANKING:
	        	return 'fa fa-sort-numeric-asc';
	        	
	        case CS_CHOICE_NPS:
	        	return 'fa fa-tachometer';
	        	
	        case CS_CHOICE_SLIDER:
	        	return 'fa fa-sliders';
	        	
	        case CS_GRID_RADIO:
	            return 'fa fa-th-large';
	
	        case CS_GRID_CHECKBOX:
	            return 'fa fa-th';
	
	        case CS_FREE_TEXT_SINGLE_LINE:
	            return 'fa fa-minus';
	
	        case CS_FREE_TEXT_MULTILINE:
	            return 'fa fa-align-justify';
	
	        case CS_FREE_TEXT_PASSWORD:
	            return 'fa fa-qrcode';
	
	        case CS_FREE_TEXT_RICH_TEXT:
	            return 'fa fa-file';
	
	        case CS_IMAGE_CHOOSE_IMAGE:
	            return 'fa fa-picture-o';
	            
            case CS_IMAGE_CHOOSE_IMAGES:
                return 'fa fa-film';
	
	        case CS_GRID_MATCHING:
	            return 'fa fa-list-ol';
	            
	        case CS_FILE_UPLOAD:
	        	return 'fa fa-upload';
	        	
	        case CS_SPECIAL_NAME:
	            return 'fa fa-user';
	            
	        case CS_SPECIAL_EMAIL:
	            return 'fa fa-envelope';
	            
	        case CS_SPECIAL_CALENDAR:
	            return 'fa fa-calendar';
	            
	        case CS_SPECIAL_ADDRESS:
	            return 'fa fa-home';
	        	
	        case CS_SPECIAL_SIGNATURE:
	        	return 'fa fa-pencil-square-o';
	    }
	}
	
	public static function loadEditor($editor, $id, $name, $content, $width = 550,  $height = 200, $cols = 60, $rows = 10, $buttons = true)
	{
	    if($editor)
	    {
	        return $editor->display($name, $content, $width, $height, $cols, $rows, $buttons, $id);
	    }
	    else
	    {
	        return '<textarea id="'.$id.'" name="'.$name.'" cols="'.$cols.'" rows="'.$rows.'" style="width:'.$width.'px;height:'.$height.'px;">'.$content.'</textarea>';
        }
	}
	
	public static function getCountriesList($name, $default, $class='')
	{
		if(empty(static::$_countries))
		{
			$countries = CJFunctions::get_country_names();
			static::$_countries = array();
			static::$_countries[] = JHTML::_('select.option', '', JText::_('JGLOBAL_SELECT_AN_OPTION'));
			
			if(!empty($countries))
			{
				foreach($countries as $country)
				{
					static::$_countries[] = JHTML::_('select.option', $country->country_code, $country->country_name);
				}
			}
		}
		
		return JHTML::_('select.genericlist', static::$_countries, $name, 'class="'.$class.'"', 'value', 'text', $default);
	}
	
	public static function buildSefSurveyUrl($url, $xhtml = true, $ssl = null)
	{
		$app = JFactory::getApplication('site');
		if (!self::$_router)
		{
			// Get the router.
			self::$_router = $app::getRouter();

			// Make sure that we have our router
			if (!self::$_router)
			{
				return null;
			}
		}

		if (!is_array($url) && (strpos($url, '&') !== 0) && (strpos($url, 'index.php') !== 0))
		{
			return $url;
		}

		// Build route.
		$uri = self::$_router->build($url);

		$scheme = array('path', 'query', 'fragment');

		/*
		 * Get the secure/unsecure URLs.
		 *
		 * If the first 5 characters of the BASE are 'https', then we are on an ssl connection over
		 * https and need to set our secure URL to the current request URL, if not, and the scheme is
		 * 'http', then we need to do a quick string manipulation to switch schemes.
		 */
		if ((int) $ssl || $uri->isSSL() || $app->get('force_ssl') == 2)
		{
			static $host_port;

			if (!is_array($host_port))
			{
				$uri2 = JUri::getInstance();
				$host_port = array($uri2->getHost(), $uri2->getPort());
			}

			// Determine which scheme we want.
			$uri->setScheme(((int) $ssl === 1 || $uri->isSSL() || $app->get('force_ssl') == 2) ? 'https' : 'http');
			$uri->setHost($host_port[0]);
			$uri->setPort($host_port[1]);
			$scheme = array_merge($scheme, array('host', 'port', 'scheme'));
		}

		$url = $uri->toString($scheme);

		// Replace spaces.
		$url = preg_replace('/\s/u', '%20', $url);

		if ($xhtml)
		{
			$url = htmlspecialchars($url);
		}
		
		$url = str_replace('/administrator/', '/', $url);
		return $url;
	}
	
	function generatePdfReport($pdfData, $mode, $params, $fileName)
	{
		$countries = CJFunctions::get_country_names();
		$responses = array();
		$include_email_in_reports = $params->get('include_email_in_reports', 0);
	
		foreach ($pdfData->responses as $response)
		{
			$responses[$response->id] = new stdClass();
			$responses[$response->id]->created_by = $response->created_by;
			$responses[$response->id]->created = $response->created;
			$responses[$response->id]->username = $response->username;
			$responses[$response->id]->name = $response->name;
				
			if($include_email_in_reports == 1)
			{
				$responses[$response->id]->email = $response->email;
			}
				
			$responses[$response->id]->questions = array();
			foreach ($pdfData->questions as $question)
			{
				$responses[$response->id]->questions[$question->id] = new stdClass();
				$responses[$response->id]->questions[$question->id]->answer = '';
				$responses[$response->id]->questions[$question->id]->question_type = $question->question_type;
			}
		}
	
		if(!empty($pdfData->entries))
		{
			foreach ($pdfData->entries as $entry)
			{
				if(isset($responses[$entry->response_id]) && isset($responses[$entry->response_id]->questions[$entry->question_id]))
				{
					if(!empty($entry->answer))
					{
						if(empty($responses[$entry->response_id]->questions[$entry->question_id]->answer))
						{
							$responses[$entry->response_id]->questions[$entry->question_id]->answer = $entry->answer;
						}
						else
						{
							$responses[$entry->response_id]->questions[$entry->question_id]->answer .= ('<br/>'.$entry->answer);
						}
	
						if(!empty($entry->answer_image) && JFile::exists(S_IMAGES_UPLOAD_DIR.'/'.$entry->answer_image))
						{
							//$image = JHtml::image(JURI::root(true).'/media/communitysurveys/images/'.$entry->answer_image, $entry->answer);
							$image = '<img src="'.JURI::root(true).'/media/communitysurveys/images/'.$entry->answer_image.'">';
							$responses[$entry->response_id]->questions[$entry->question_id]->answer .= '<br/>'.$image;
						}
					}
	
					if(!empty($entry->answer2))
					{
						if(empty($responses[$entry->response_id]->questions[$entry->question_id]->answer))
						{
							$responses[$entry->response_id]->questions[$entry->question_id]->answer = $entry->answer2;
						}
						else
						{
							$responses[$entry->response_id]->questions[$entry->question_id]->answer .= ('<br/>'.$entry->answer2);
						}
					}
	
					if(!empty($entry->free_text))
					{
						// do special types formatting //
						if($responses[$entry->response_id]->questions[$entry->question_id]->question_type == S_SPECIAL_NAME)
						{
							$names = explode('|', $entry->free_text);
							if(!empty($names)) 
							{
								$entry->free_text = $names[0].'. '.$names[1].' '.$names[2];
							} 
							else 
							{
								$entry->free_text = '';
							}
						} 
						else if($responses[$entry->response_id]->questions[$entry->question_id]->question_type == S_SPECIAL_ADDRESS)
						{
							$parts = explode('|||', $entry->free_text);
								
							if(count($parts) == 7)
							{
								$entry->free_text = '<address><strong>'.CjLibUtils::escape($parts[0]).'</strong><br>';
								$entry->free_text .= CjLibUtils::escape($parts[1]).'<br>';
									
								if(!empty($parts[2]))
								{
									$entry->free_text .= CjLibUtils::escape($parts[2]).'<br>';
								}
									
								$entry->free_text .= CjLibUtils::escape($parts[3]).', '.CjLibUtils::escape($parts[4]).', '.
										CjLibUtils::escape($parts[6]).'<br>';
										$entry->free_text .= !empty($countries[$parts[5]]) ? $countries[$parts[5]]->country_name : CjLibUtils::escape($parts[5]);
							} 
							else 
							{
	
								$entry->free_text = '';
							}
						}
						// do special types formatting //
	
						if(empty($responses[$entry->response_id]->questions[$entry->question_id]->answer))
						{
							$responses[$entry->response_id]->questions[$entry->question_id]->answer = $entry->free_text;
						}
						else
						{
							$responses[$entry->response_id]->questions[$entry->question_id]->answer .= ('<br/>'.$entry->free_text);
						}
					}
				}
			}
		}
	
		$response_rows = array();
	
		foreach ($responses as $id=>$response)
		{
			$string = '<table class="table table-striped" width="100%">';
			$string = $string.'<tr><th width="30%"><strong>Response ID:</strong></th><td width="70%">'.$id.'</td></tr>';
			$string = $string.'<tr><th><strong>Response Date:</strong></th><td>'.$response->created.'</td></tr>';
			$string = $string.'<tr><th><strong>User ID:</strong></th><td>'.$response->created_by.'</td></tr>';
			$string = $string.'<tr><th><strong>Username:</strong></th><td>'.$response->username.'</td></tr>';
			$string = $string.'<tr><th><strong>User Display Name:</strong></th><td>'.$response->name.'</td></tr>';
				
			if($include_email_in_reports == 1)
			{
				$string = $string.'<tr><td><strong>Email:</strong></td><td>'.$response->email.'</td></tr>';
			}
				
			foreach ($pdfData->questions as $question)
			{
				$string = $string.'<tr><td colspan="2">&nbsp;<hr></td></tr>';
				$string = $string.'<tr><th colspan="2"><h3>'.$question->title.'</h3></th></tr>';
	
				if(!empty($question->description))
				{
					$string = $string.'<tr><td colspan="2">'.$question->description.'</td></tr>';
				}
	
				$string = $string.'<tr><td colspan="2">&nbsp;</td></tr>';
				$string = $string.'<tr><td colspan="2">'.$response->questions[$question->id]->answer.'</td></tr>';
			}
				
			$string = $string.'</table>';
				
			array_push($response_rows, $string);
		}
	
		// create new PDF document
		require_once JPATH_ROOT.'/components/com_communitysurveys/helpers/route.php';
		$pdf = new MYPDF('P', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
	
		// set default header data
		$pdf->SetHeaderData('logo.png', PDF_HEADER_LOGO_WIDTH, $pdfData->title, '');
	
		// set document information
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor('corejoomla.com');
		$pdf->SetTitle('Survey Report');
		$pdf->SetSubject('Survey Responses Report');
		$pdf->SetKeywords('survey, report');
	
		// set header and footer fonts
		$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
		$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
	
		// set default monospaced font
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
	
		//set margins
		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
	
		//set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
	
		//set image scale factor
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	
		// ---------------------------------------------------------
	
		// set font
		$pdf->SetFont('freesans');
	
		foreach ($response_rows as $i=>$response)
		{
			$pdf->AddPage();
			$pdf->writeHTML($response, true, false, true, false, '');
			$pdf->lastPage();
		}
	
		$pdf->Output($fileName, $mode);
	}
	
	public static function renderLayout($layoutFile, $displayData = null, $basePath = '', $options = null)
	{
		// Make sure we send null to JLayoutFile if no path set
		$basePath = empty($basePath) ? null : $basePath;
		$options = is_array($options) ? $options : array();
		$options = array_merge(array('client' => 0, 'component' => 'com_communitysurveys', 'debug' => false), $options);
		$layout = new JLayoutFile($layoutFile, $basePath, $options);
		$renderedLayout = $layout->render($displayData);
	
		return $renderedLayout;
	}
	
	
	/**
	 * Formats a line (passed as a fields  array) as CSV and returns the CSV as a string.
	 * Adapted from http://us3.php.net/manual/en/function.fputcsv.php#87120
	 */
	public static function arrayToCsv( array &$fields, $delimiter = ',', $enclosure = '"', $encloseAll = false, $nullToMysqlNull = true )
	{
	    $delimiter_esc = preg_quote($delimiter, '/');
	    $enclosure_esc = preg_quote($enclosure, '/');
	    
	    $output = array();
	    foreach ( $fields as $field )
	    {
	        if ($field === null && $nullToMysqlNull)
	        {
	            $output[] = 'NULL';
	            continue;
	        }
	        
	        // Enclose fields containing $delimiter, $enclosure or whitespace
	        if ( $encloseAll || preg_match( "/(?:${delimiter_esc}|${enclosure_esc}|\s)/", $field ) )
	        {
	            $output[] = $enclosure . str_replace($enclosure, $enclosure . $enclosure, $field) . $enclosure;
	        }
	        else
	        {
	            $output[] = $field;
	        }
	    }
	    
	    return implode( $delimiter, $output );
	}
}