<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

if (!class_exists('TCPDF'))
{
//     require_once(CJLIB_PATH.'/lib/tcpdf/config/lang/eng.php');
	require_once(CJLIB_PATH.'/lib/tcpdf/tcpdf.php');
}

class CJQPDF extends TCPDF 
{
	public function Footer() 
	{
		$params = JComponentHelper::getParams('com_communitysurveys');
		$fontname = $params->get('pdf_fontname', 'helvetica');
		
		// Position at 15 mm from bottom
		$this->SetY(-15);
		// Set font
		$this->SetFont($fontname, 'I', 8);
// 		$pdf->setRTL(true);
		
		// Page number
		$this->Cell(0, 10, 'Powered by Community Surveys - www.corejoomla.com', 0, false, 'L', 0, '', 0, false, 'T', 'M');
		$this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'R', 0, '', 0, false, 'T', 'M');
	}
}
