<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$user 		= JFactory::getUser();
$access 	= $user->getAuthorisedViewLevels();
$params 	= $displayData['params'];
$item 		= $displayData['category'];
$maxlevel 	= $displayData['maxlevel'];
$columns	= (int) $params->get('max_category_columns', 3);
$spanLg 	= (int) 12 / $columns;
$spanMd 	= (int) 12 / $columns;;
$spanSm 	= 6;
$spanXs 	= 12;
$catParams  = $item->getParams();
$catImage   = $catParams->get('image');
?>
<div class="media">
	<?php 
	$categoryUrl = CommunitySurveysHelperRoute::getCategoryRoute($item);
	if($params->get('show_description_image', 1) == 1 && !empty($catImage))
	{
		?>
		<div class="media-left hidden-phone">
			<a href="#" class="thumbnail" onclick="return false;">
				<img src="<?php echo $catParams->get('image');?>" alt="<?php echo $this->escape($catParams->get('image_alt'));?>" class="media-object" style="max-width: 128px;">
			</a>
		</div>
		<?php 
	}
	?>
	<div class="media-body">
        <?php 
        if($item->parent_id)
        {
            ?>
            <h4 class="panel-title">
                <a href="<?php echo JRoute::_($categoryUrl);?>"><?php echo $this->escape($item->title);?></a>
                
                <?php if($params->get('show_feed_link', 1) == 1):?>
        		<a href="<?php echo JRoute::_($categoryUrl.'&format=feed&type=rss');?>" 
        			title="<?php echo JText::_('COM_COMMUNITYSURVEYS_RSS_FEED');?>" data-toggle="tooltip">
        			<sup class="margin-left-5"><small><i class="fa fa-rss-square"></i></small></sup>
        		</a>
        		<?php endif;?>
    		</h4>
            <?php
        }

        if(!empty($item->description) && $params->get('show_description'))
        {
        	echo JHtml::_('content.prepare', $item->description, '', 'com_communitysurveys.categories');
        }
		?>
	</div>
</div>
<?php 
if($item->parent_id)
{
    ?>
    <hr>
    <?php
}

if ($maxlevel != 0 && count($item->getChildren()) > 0) 
{
	$categories = $item->getChildren();
	$itemNum = 0;
	?>
	<div class="row">
    	<?php
    	foreach ($categories as $node)
    	{
    		if(in_array($node->access, $access) && $user->authorise('core.respond', 'com_communitysurveys.category.'.$node->id))
    		{
    			?>
    			<div class="col-lg-<?php echo $spanLg?> col-md-<?php echo $spanMd?> col-sm-<?php echo $spanSm?> col-sm-<?php echo $spanXs?> margin-bottom-5">
					<a href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getCategoryRoute($node));?>">
						<?php echo $this->escape($node->title);?>
						<span class="text-muted visible-xs">(<?php echo JText::plural('COM_COMMUNITYSURVEYS_NUM_SURVEYS', $node->numitems);?>)</span>
					</a>
					
					<?php if($params->get('show_feed_link', 1) == 1):?>
					<a href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getCategoryRoute($node).'&format=feed&type=rss');?>" 
						title="<?php echo JText::_('COM_COMMUNITYSURVEYS_RSS_FEED');?>" data-toggle="tooltip">
						<sup class="margin-left-5"><small><i class="fa fa-rss-square"></i></small></sup>
					</a>
					<?php endif;?>
					
					<small class="text-muted">(<?php echo $node->numitems;?>)</small>
    			</div>
    			<?php
    			$itemNum++;
    		} 
    	}
    	?>
    </div>
    <?php
}