<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$params 	= $displayData['params'];
$item 		= $displayData['item'];
$editor 	= $displayData['editor'];
?>
<div role="tabpanel">
	<ul class="nav nav-tabs" role="tablist" id="qntab-<?php echo $item->id;?>">
		<li class="pull-right">
			<button type="button" class="btn btn-primary" onclick="CjSurveyApi.submitAjaxForm(this, '#qForm<?php echo $item->id?>', 'question.save', 'onBeforeSaveQuestion', 'onAfterSaveQuestion')">
				<?php echo JText::_('JSAVE');?>
			</button>
			<button type="button" class="btn btn-default btn-close-question">
				<?php echo JText::_('JCANCEL');?>
			</button>
		</li>
		<li role="presentation" class="active">
			<a href="#content-<?php echo $item->id?>" aria-controls="#content-<?php echo $item->id?>" role="tab" data-toggle="tab" onclick="return false;">
				<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_CONTENT');?>
			</a>
		</li>
	</ul>
	<div class="tab-content">
		<div role="tabpanel" class="tab-pane active" id="content-<?php echo $item->id?>">
			<div class="form-group">
				<label for="title-<?php echo $item->id;?>"><?php echo JText::_('JGLOBAL_TITLE');?><sup>*</sup>:</label>
				<input type="text" name="title" id="title-<?php echo $item->id;?>" value="<?php echo $this->escape($item->title);?>" class="input-xlarge required">
			</div>
			<div class="form-group<?php echo $params->get('load_editor') ? '' : ' js-editor-tinymce';?>">
				<label for="description_<?php echo $item->id;?>"><?php echo JText::_('JGLOBAL_DESCRIPTION');?>:</label>
				<?php echo SurveyHelper::loadEditor($editor, 'description_'.$item->id, 'description', $item->description);?>
			</div>
		</div>
	</div>
</div>