<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

$document	= JFactory::getDocument();
$data		= $displayData['data'];
$item		= $data->item;
$questions	= $data->report;
$params 	= $data->params;
$theme 		= $params->get('theme', 'default');

$document->addScript('https://www.google.com/jsapi');
$document->addScriptDeclaration('google.load("visualization", "1", {packages:["corechart"]});');
?>
<div class="consolidated-report">
	<?php 
	if(!empty($questions))
	{
		if(empty($data->print) && $params->get('show_filter', 1))
		{
			echo $this->sublayout('filter', array('data'=>$data));
		}
		
    	foreach ($questions as $item)
    	{
    		?>
    		<div class="panel panel-<?php echo $theme;?>">
    			<div class="panel-heading clearfix">
    				<div class="statistics pull-right">
	    				<i class="fa fa-comments"></i> <?php echo JText::sprintf('COM_COMMUNITYSURVEYS_NUM_TOTAL_RESPONSES', $item->votes);?>
	    				<?php if($item->question_type == CS_GRID_RADIO):?>
						<button class="btn btn-xs btn-primary toggle-charts-button" type="button">
							<?php echo JText::_('COM_COMMUNITYSURVEYS_TOGGLE_CHARTS');?>
						</button>
						<?php endif;?>
	    			</div>
    				<h4 class="panel-title">
    					<i class="fa fa-caret-right"></i> <?php echo $item->title;?>
    				</h4>
    			</div>
    			<?php
    			$description = strip_tags($item->description);
    			if(!empty($description))
    			{
    				?>
    				<div class="panel-body"><?php echo $item->description;?></div>
    				<?php
    			}
    			
    			$layouts = array(
    					CS_PAGE_HEADER => 'page_header',
    					CS_CHOICE_RADIO => 'choice',
    					CS_CHOICE_CHECKBOX => 'choice',
    					CS_CHOICE_SELECT => 'choice',
    					CS_CHOICE_RANKING => 'ranking',
    					CS_CHOICE_MULTIRATING => 'multirating',
    					CS_CHOICE_NPS => 'nps',
    					CS_CHOICE_SLIDER => 'slider',
    					CS_GRID_RADIO => 'grid',
    					CS_GRID_CHECKBOX => 'grid',
    					CS_GRID_MATCHING => 'grid',
    					CS_FREE_TEXT_SINGLE_LINE => 'textbox',
    					CS_FREE_TEXT_MULTILINE => 'textbox',
    					CS_FREE_TEXT_PASSWORD => 'textbox',
    					CS_FREE_TEXT_RICH_TEXT => 'rich_textbox',
    					CS_IMAGE_CHOOSE_IMAGE => 'image',
    					CS_IMAGE_CHOOSE_IMAGES => 'image',
    					CS_SPECIAL_EMAIL => 'email',
    					CS_SPECIAL_NAME => 'name',
    					CS_SPECIAL_CALENDAR => 'calendar',
    					CS_SPECIAL_ADDRESS => 'address',
    					CS_SPECIAL_SIGNATURE => 'signature',
    					CS_FILE_UPLOAD => 'fileupload'
    			);
    			
    			echo $this->sublayout($layouts[$item->question_type], array('item'=>$item, 'params'=>$params, 'print'=>$data->print));
    			?>
    		</div>
    		<?php
    	}
	}
	else
	{
	    ?>
		<p class="alert alert-info"><i class="fa fa-info-circle"></i> <?php echo JText::_('JGLOBAL_NO_MATCHING_RESULTS');?></p>
		<?php
	}
	?>
	<input id="cjpageid" value="reports" type="hidden" />

	<div id="modalTextAnswers" class="modal fade">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title"><?php echo JText::_('COM_COMMUNITYSURVEYS_TEXT_ANSWERS')?></h4>
				</div>
				<div class="modal-body"></div>
				<div class="modal-footer">
					<button type="button" class="btn btn-default" data-dismiss="modal"><?php echo JText::_('JCANCEL');?></button>
				</div>
			</div>
		</div>
	</div>
</div>