<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$params 			= $displayData['params'];
$item 				= $displayData['item'];

if(!empty($item->textResponses))
{
	?>
	<table class="table table-striped table-hover">
		<thead>
			<tr>
				<th width="25%"><?php echo JText::_('JGLOBAL_USERNAME');?></th>
				<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ANSWER');?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			foreach ($item->textResponses as $response)
			{
				$parts = explode('|||', $response->free_text);
				?>
				<tr>
					<td><?php echo !empty($response->author) ? $this->escape($response->author) : JText::_('COM_COMMUNITYSURVEYS_GUEST');?></td>
					<td>
						<address class="no-margin-bottom">
							<strong><?php echo $this->escape($parts[0]);?></strong><br>
							<?php echo $this->escape($parts[1]);?>, <?php echo $this->escape($parts[2]);?><br>
							<?php echo $this->escape($parts[3]);?>, <?php echo $this->escape($parts[4]);?><br>
							<?php echo $this->escape($parts[5]);?>, <?php echo $this->escape($parts[6]);?>
						</address>
					</td>
				</tr>
				<?php
			}
			?>
			<tr>
				<td colspan="2">
					<a href="#" onclick="document.surveyForm.qid.value=<?php echo $item->id;?>; CjSurveyApi.submitAjaxForm(this, '#surveyForm', 'reports.getanswers', 'onBeforeGetTextAnswers', 'onAfterGetTextAnswers'); return false">
						<i class="fa fa-comments"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_VIEW_ALL_RESPONSES');?>
					</a>
				</td>
			</tr>
		</tbody>
	</table>
	<?php
}
else
{
	echo JText::_('COM_COMMUNITYSURVEYS_NO_ANSWER_PROVIDED');
}
?>
