<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

$user 		= JFactory::getUser();
$data		= $displayData['data'];
$item		= $data->item;
$params 	= $data->params;
$theme 		= $params->get('theme', 'default');
$stats		= $item->stats;
$uri        = CommunitySurveysHelperRoute::getReportsRoute($item->id, $item->language);
?>

<div class="dashboard clearfix">
	<?php
	$responses = array();
	if(!empty($stats->daywise))
	{
    	foreach ($stats->daywise as $date=>$value)
    	{
    		$responses[] = "[new Date('".$date."'),".$value['posts']."]";
    	}
	}
		
	$countries = array();
	if(!empty($stats->countrywise))
	{
    	foreach ($stats->countrywise as $country=>$value)
    	{
    	    if(!empty($value['country_name']))
    	    {
                $countries[] = '["'.$this->escape($value['country_name']).'",'.$value['posts'].']';
    	    }
    	}
	}
	?>
	<div role="tabpanel">
	   <ul class="nav nav-tabs" role="tablist">
	       <li role="presentation" class="active">
	           <a href="#global-activity" aria-controls="global-activity" role="tab" data-toggle="tab">
	               <i class="fa fa-globe"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_GEO_ACTIVITY');?>
	           </a>
	       </li>
	       <li role="presentation">
	           <a href="#daily-trends" aria-controls="daily-trends" role="tab" data-toggle="tab">
	               <i class="fa fa-line-chart"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_DAILY_TRENDS');?>
	           </a>
            </li>
	   </ul>
	   <div class="tab-content">
	       <div role="tabpanel" class="tab-pane active" id="global-activity">
	           <div id="geo-chart" style="width: 100%; height: 300px; max-height: 300px;"></div>
	       </div>
	       <div role="tabpanel" class="tab-pane active" id="daily-trends">
	           <div id="trend-chart" style="width: 100%; max-height: 300px;"></div>
	       </div>   
        </div>
	</div>
	
	<script type="text/javascript">
		google.load("visualization", "1", {packages:["annotatedtimeline", "geochart"]});
		google.setOnLoadCallback(function(){
			var options = {'height': 300, 'chartArea': {'width': '80%', 'height': '60%'}, 'displayAnnotations': false};
			
			var data = google.visualization.arrayToDataTable([['Country', 'Posts'], <?php echo implode(',', $countries)?>]);
			var chart = new google.visualization.GeoChart(document.getElementById('geo-chart'));
			chart.draw(data, options);

			var data = google.visualization.arrayToDataTable([['<?php echo JText::_('JDATE')?>', '<?php echo JText::_('COM_COMMUNITYSURVEYS_RESPONSES_LABEL')?>'], <?php echo implode(',', $responses)?>]);
			var chart = new google.visualization.AnnotatedTimeLine(document.getElementById('trend-chart'));
			chart.draw(data, options);
			document.getElementById('daily-trends').className = 'tab-pane';
		});
	</script>
</div>

<hr/>

<div class="panel panel-<?php echo $theme;?>">
	<div class="panel-heading">
		<h4 class="panel-title"><?php echo JText::_('COM_COMMUNITYSURVEYS_REPORTS');?></h4>
	</div>
	<div class="table-responsive">
		<table class="table table-bordered table-striped table-hover">
			<tr>
				<td><?php echo JText::_('COM_COMMUNITYSURVEYS_TOTAL_COMPLETED_RESPONSES');?></td>
				<td width="15%"><?php echo $stats->completed;?></td>
				<td width="30%">
					<a href="<?php echo JRoute::_($uri.'&id='.$item->id.'&layout=consolidated')?>">
						<?php echo JText::_('COM_COMMUNITYSURVEYS_VIEW_CONSOLIDATE_REPORT');?>
					</a>
				</td>
			</tr>
			<tr>
				<td><?php echo JText::_('COM_COMMUNITYSURVEYS_TOTAL_RESPONSES');?></td>
				<td><?php echo $stats->responses;?></td>
				<td>
					<a href="<?php echo JRoute::_($uri.'&id='.$item->id.'&layout=responses')?>">
						<?php echo JText::_('COM_COMMUNITYSURVEYS_VIEW_ALL_RESPONSES');?>
					</a>
				</td>
			</tr>
			<tr>
				<td><?php echo JText::_('COM_COMMUNITYSURVEYS_TOTAL_COUNTRIES_PARTICIPATED');?></td>
				<td><?php echo $stats->countries;?></td>
				<td>
					<a href="<?php echo JRoute::_($uri.'&id='.$item->id.'&layout=locations')?>">
						<?php echo JText::_('COM_COMMUNITYSURVEYS_VIEW_COUNTRY_REPORT');?>
					</a>
				</td>
			</tr>
			<tr>
				<td><?php echo JText::_('COM_COMMUNITYSURVEYS_TOTAL_BROWSERS_USED');?></td>
				<td><?php echo $stats->browsers;?></td>
				<td>
					<a href="<?php echo JRoute::_($uri.'&id='.$item->id.'&layout=browsers')?>">
						<?php echo JText::_('COM_COMMUNITYSURVEYS_VIEW_BROWSER_REPORT');?>
					</a>
				</td>
			</tr>
			<tr>
				<td><?php echo JText::_('COM_COMMUNITYSURVEYS_TOTAL_OS_USED');?></td>
				<td><?php echo $stats->oses;?></td>
				<td>
					<a href="<?php echo JRoute::_($uri.'&id='.$item->id.'&layout=platforms')?>">
						<?php echo JText::_('COM_COMMUNITYSURVEYS_VIEW_OS_REPORT');?>
					</a>
				</td>
			</tr>
			<tr>
				<td><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_EXPORT_SURVEY');?></td>
				<td>-</td>
				<td>
					<a class="margin-right-20" href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getSurveyRoute($item->id, $item->catid, $item->language).'&format=xml')?>" target="_blank">
						<i class="fa fa-download"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_SURVEY');?>
					</a>
					<a href="<?php echo JRoute::_($uri.'&id='.$item->id.'&format=csv')?>" target="_blank">
						<i class="fa fa-download"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_REPORTS');?>
					</a>
				</td>
			</tr>
		</table>
	</div>
</div>