<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;
require_once JPATH_ROOT.'/components/com_communitysurveys/helpers/route.php';

$input		= JFactory::getApplication()->input;
$data		= $displayData['data'];
$state		= $data->state;
$view		= $input->getCmd('view', 'reports');
$layout		= $input->getCmd('layout', 'consolidated');
$filters 	= $data->filterForm->getGroup('filter');
$lists		= $data->filterForm->getGroup('list');
$isHidden	= empty($data->activeFilters);

$displayData['options'] = !empty($displayData['options']) ? $displayData['options'] : array();
$options = array( 
		'filtersHidden' => isset($displayData['options']['filtersHidden']) ? $displayData['options']['filtersHidden'] : empty($data->activeFilters),
		'defaultLimit'        => isset($displayData['options']['defaultLimit']) ? $displayData['options']['defaultLimit'] : JFactory::getApplication()->get('list_limit', 20),
		'searchFieldSelector' => '#filter_search',
		'orderFieldSelector'  => '#list_fullordering'
);

JHtml::_('searchtools.form', '#adminForm', $options);
?>
<div class="accordion report-filter" id="report-filter">
	<div class="accordion-group">
		<div class="accordion-heading">
			<a class="js-stools-btn-filter accordion-toggle" data-toggle="collapse" data-parent="#report-filter" href="#reportFilterFields">
				<?php echo JText::_('COM_COMMUNITYSURVEYS_FILTER_TITLE');?>
			</a>
		</div>
		<div id="reportFilterFields" class="accordion-body">
			<div class="accordion-inner js-stools-container-filters<?php echo $isHidden ? '' : ' shown';?>">
				<div class="form-horizontal">
					<div class="row-fluid">
						<div class="span6">
							<div class="js-stools-field-filter control-group">
								<label class="control-label" for="filter_search">
									<?php echo JText::_('JSEARCH_FILTER')?>
								</label>
								<div class="controls">
									<input type="text" id="filter_search" placeholder="<?php echo JText::_('JSEARCH_FILTER');?>">
								</div>
							</div>
			 
			 				<div class="js-stools-field-filter control-group">
			 					<label class="control-label" for="filter_search">
			 						<?php echo JText::_('COM_COMMUNITYSURVEYS_FILTER_START_DATE');?>
			 					</label>
			 					<div class="controls" style="position: relative;">
									<div class="input-append input-group datetime" data-format="YYYY-MM-DD HH:mm:ss">
										<input type="text" name="start_date" class="form-control" value="<?php echo $this->escape($state->get($layout.'.start_date', ''));?>" 
											placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_FILTER_START_DATE');?>">
										<span class="add-on input-group-addon"><span class="fa fa-calendar"></span></span>
									</div>
								</div>
							</div>
							
							<div class="js-stools-field-filter control-group">
								<label class="control-label" for="filter_search">
									<?php echo JText::_('COM_COMMUNITYSURVEYS_FILTER_END_DATE');?>
								</label>
								<div class="controls" style="position: relative;">
									<div class="input-append input-group datetime" data-format="YYYY-MM-DD HH:mm:ss">
										<input type="text" name="end_date" class="form-control" value="<?php echo $this->escape($state->get($layout.'.end_date', ''));?>" 
											placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_FILTER_END_DATE');?>">
										<span class="add-on input-group-addon"><span class="fa fa-calendar"></span></span>
									</div>
								</div>
							</div>
							
							<div class="js-stools-field-filter control-group">
								<label class="control-label" for="filter_author_id">
									<?php echo JText::_('COM_COMMUNITYSURVEYS_FILTER_AUTHOR_LABEL');?>
								</label>
								<div class="controls">
									<?php echo $filters['filter_author_id']->input;?>
								</div>
							</div>
							
							<div class="js-stools-field-filter control-group">
								<label class="control-label" for="filter_published">
									<?php echo JText::_('COM_COMMUNITYSURVEYS_FILTER_PUBLISHED_LABEL');?>
								</label>
								<div class="controls">
									<?php echo $filters['filter_published']->input;?>
								</div>
							</div>
							
							<div class="js-stools-field-filter control-group">
								<label class="control-label" for="filter_response_status">
									<?php echo JText::_('COM_COMMUNITYSURVEYS_FILTER_RESPONSE_STATUS_LABEL');?>
								</label>
								<div class="controls">
									<?php echo $filters['filter_response_status']->input;?>
								</div>
							</div>
						</div>
						<div class="span6">
							<div class="js-stools-field-filter control-group">
								<label class="control-label" for="filter_country">
									<?php echo JText::_('COM_COMMUNITYSURVEYS_FILTER_COUNTRY_LABEL');?>
								</label>
								<div class="controls">
									<?php echo $filters['filter_country']->input;?>
								</div>
							</div>
							
							<div class="js-stools-field-filter control-group">
								<label class="control-label" for="filter_city">
									<?php echo JText::_('COM_COMMUNITYSURVEYS_FILTER_CITY_LABEL');?>
								</label>
								<div class="controls">
									<?php echo $filters['filter_city']->input;?>
								</div>
							</div>
							<div class="js-stools-field-filter control-group">
								<label class="control-label" for="filter_platform">
									<?php echo JText::_('COM_COMMUNITYSURVEYS_FILTER_PLATFORM_LABEL');?>
								</label>
								<div class="controls">
									<?php echo $filters['filter_platform']->input;?>
								</div>
							</div>
							
							<div class="js-stools-field-filter control-group">
								<label class="control-label" for="filter_browser">
									<?php echo JText::_('COM_COMMUNITYSURVEYS_FILTER_BROWSER_LABEL');?>
								</label>
								<div class="controls">
									<?php echo $filters['filter_browser']->input;?>
								</div>
							</div>
							<div class="js-stools-field-filter control-group">
								<label class="control-label" for="list_fullordering">
									<?php echo JText::_('COM_COMMUNITYSURVEYS_LIST_FULL_ORDERING');?>
								</label>
								<div class="controls">
									<?php echo $lists['list_fullordering']->input;?>
								</div>
							</div>
							
							<div class="js-stools-field-filter control-group">
								<label class="control-label" for="list_fullordering">
									<?php echo JText::_('COM_COMMUNITYSURVEYS_LIST_LIMIT');?>
								</label>
								<div class="controls">
									<?php echo $lists['list_limit']->input;?>
								</div>
							</div>
						</div>
					</div>
					
					<hr/>
					<?php if(strlen($data->filter_rules) > 3):?>
        			<div class="questions-filter">
        				<p><?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTIONS_FILTER_DESC');?></p>
        				<div id="filter-rules-builder"></div>
        				<span style="display: none;" id="filter-rules-json"><?php echo $data->filter_rules;?></span>
        				<span style="display: none;" id="filter-rules-basic"><?php echo $state->get('advancedfilter.conditions');?></span>
        			</div>
        			<?php endif;?>
							
					<div class="actions">
						<input type="hidden" name="conditions[]" value="">
						<button type="submit" class="btn btn-primary" onclick="return CjSurveyApi.buildRules();"><?php echo JText::_('COM_COMMUNITYSURVEYS_APPLY_FILTER');?></button>
						<button type="button" class="btn btn-default js-stools-btn-clear" data-original-title="Clear"><?php echo JText::_('JSEARCH_FILTER_CLEAR');?></button>
					</div>
				</div>
			</div>
			
			<input type="hidden" id="filter_conditions" name="filter_conditions" value="">
			<input type="hidden" name="option" value="com_communitysurveys">
			<input type="hidden" name="view" value="<?php echo $view;?>">
			<input type="hidden" name="layout" value="<?php echo $layout;?>">
			<input type="hidden" name="id" value="<?php echo $data->item->id;?>">
		</div>
	</div>
</div>
