<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 				= $displayData['item'];
$free_text 			= '';
$required			= $item->mandatory ? ' required' : '';
?>
<ul class="list-group no-margin-left">
	<li class="list-group-item">
		<?php 
		foreach ($item->responses as $response)
		{
			if(!empty($response->free_text))
			{
				$free_text = $this->escape($response->free_text);
				break;
			}
		}
		
		if(!empty($free_text))
		{
			$names = explode('|', $free_text, 3);
		}
		
		if(empty($names) || count($names) != 3)
		{
			$names = array('', '', '');
		}
		
		if(empty($names[1]) && $item->params->get('autofill_name', 0) == 1)
		{
			$name = explode(' ', JFactory::getUser()->name, 2);
			if(count($name) == 2) 
			{
				$names[1] = $name[0];
				$names[2] = $name[1];
			}
			else 
			{
				$names[1] = JFactory::getUser()->name;
			}
		}
		?>
		<div class="row">
			<div class="form-group">
				<div class="form-inline">
					<div class="col-md-1">
						<label class="sr-only" for="user-name-<?php echo $item->id;?>-title"><?php echo JText::_('COM_COMMUNITYSURVEYS_TITLE');?></label>
						<input type="text" 
							name="user-name-<?php echo $item->id;?>[]" 
							id="user-name-<?php echo $item->id;?>-title" 
							class="form-control<?php echo !$item->params->get('hide_title_field') ? $required : '';?>" 
							value="<?php echo $names[0];?>" 
							placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_TITLE');?>" 
							aria-label="<?php echo JText::_('COM_COMMUNITYSURVEYS_TITLE');?>" 
							style="width: 100%;<?php echo $item->params->get('hide_title_field') ? 'display: none;' : '';?>">
					</div>
					<div class="col-md-3">
						<label class="sr-only" for="user-name-<?php echo $item->id;?>-fname"><?php echo JText::_('COM_COMMUNITYSURVEYS_FIRST_NAME');?></label>
						<input type="text" 
							name="user-name-<?php echo $item->id;?>[]" 
							id="user-name-<?php echo $item->id;?>-fname" 
							class="form-control<?php echo $required;?>" 
							value="<?php echo $names[1];?>" 
							placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_FIRST_NAME');?>" 
							aria-label="<?php echo JText::_('COM_COMMUNITYSURVEYS_FIRST_NAME');?>"
							style="width: 100%">
					</div>
					<div class="col-md-3">
						<label class="sr-only" for="user-name-<?php echo $item->id;?>-lname"><?php echo JText::_('COM_COMMUNITYSURVEYS_LAST_NAME');?></label>
						<input type="text" 
							name="user-name-<?php echo $item->id;?>[]" 
							id="user-name-<?php echo $item->id;?>-lname" 
							class="form-control<?php echo $required;?>" 
							value="<?php echo $names[2];?>" 
							placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_LAST_NAME');?>" 
							aria-label="<?php echo JText::_('COM_COMMUNITYSURVEYS_LAST_NAME');?>"
							style="width: 100%">
					</div>
				</div>
			</div>
		</div>
	</li>
</ul>