<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 				= $displayData['item'];
$free_text			= '';
$customAnswerPH     = $item->params->get('custom_answer_placeholder', JText::_('COM_COMMUNITYSURVEYS_ENTER_YOUR_ANSWER'));
?>
<div class="list-group ranking-options">
	<?php 
	// first reorder as per already selected order, if any
	if(!empty($item->responses))
	{
		$answers = array();
		usort($item->responses, function($a, $b)
		{
			return strcmp($a->column_id, $b->column_id);
		});
		
		foreach ($item->responses as $response)
		{
			foreach ($item->answers as $answer)
			{
				if($answer->id == $response->answer_id)
				{
					$answers[] = $answer;
					break;
				}
			}
		}
		
		$item->answers = $answers;
	}
	else if($item->params->get('randomize_answers'))
	{
		shuffle($item->answers);
	}
	
	foreach ($item->answers as $i => $answer)
	{
		$rank = 0;
		foreach ($item->responses as $response)
		{
			if($answer->id == $response->answer_id)
			{
				$rank = $response->column_id;
			}
			
			if(!empty($response->free_text))
			{
				$free_text = CjLibUtils::escape($response->free_text);
			}
		}
		?>
		<a href="#" class="list-group-item ranking-option" onclick="return false;" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_CLICK_DRAG_TO_SORT');?>">
			<i class="fa fa-arrows"></i> &nbsp;<?php echo $this->escape($answer->title);?>
			<input type="hidden" name="answer-<?php echo $item->id.'-'.$answer->id;?>" value="<?php echo $rank ? $rank : $i + 1;?>"/>
		</a>
		<?php
	}
	?>
</div>
<?php 
if($item->custom_choice == 1)
{
?>
	<div class="list-group-item">
		<input type="text" name="free-text-<?php echo $item->id;?>" class="valid" style="margin-bottom: 0;"
			value="<?php echo $free_text;?>" placeholder="<?php echo $customAnswerPH;?>" aria-required="false" aria-label="<?php echo $customAnswerPH;?>">
	</div>
	<?php 
}
?>