<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 				= $displayData['item'];
$free_text 			= '';
$required			= $item->mandatory ? ' class="required"' : '';
$customAnswerPH     = $item->params->get('custom_answer_placeholder', JText::_('COM_COMMUNITYSURVEYS_ENTER_YOUR_ANSWER'));
?>
<ul class="list-group no-margin-left">
	<li class="list-group-item">
		<select name="answer-<?php echo $item->id;?>"<?php echo $required;?> aria-label="<?php echo $this->escape(strip_tags($item->title));?>">
			<option value=""><?php echo JText::_('JGLOBAL_SELECT_AN_OPTION');?></option>
			<?php
			foreach ($item->answers as $i=>$answer)
			{
				$selected = false;
				$rules = '';
				foreach ($item->responses as $response)
				{
					if($answer->id == $response->answer_id)
					{
						$selected = true;
					} 
					else if(!empty($response->free_text))
					{
						$free_text = CjLibUtils::escape($response->free_text);
					}
				}
				
				if(isset($item->rule_selected[$answer->id]))
				{
					$rules = ' showitems="'.implode(',', $item->rule_selected[$answer->id]).'"';
				}
				?>
				<option value="<?php echo $answer->id;?>"<?php echo $selected ? ' selected="selected"' : '';?><?php echo $rules;?>><?php echo $this->escape($answer->title);?></option>
				<?php
			}
			?>
		</select>
	</li>
	<?php
	if($item->custom_choice == 1)
	{
		?>
		<li class="list-group-item">
			<input type="text" name="free-text-<?php echo $item->id;?>" class="input-xlarge valid"  value="<?php echo $free_text;?>" 
				placeholder="<?php echo $customAnswerPH;?>" aria-required="false" aria-label="<?php echo $customAnswerPH;?>">
		</li>
		<?php
	}
	?>
</ul>