<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 				= $displayData['item'];
$free_text 			= '';
$required			= $item->mandatory ? ' required' : '';
$answers			= array();

if(!empty($item->answers))
{
	foreach ($item->answers as $answer)
	{
		$answers[] = array($answer->id, $this->escape($answer->title));
	}
}
?>
<div class="panel-body">
	<table class="slider-table" style="width: 100%; padding-top: 30px;">
		<?php if(!empty($item->answers)):?>
		<thead>
			<tr>
				<td>
					<div style="position: relative; margin-bottom: 20px;">
					<?php 
					foreach ($item->answers as $i=>$answer)
					{
						$left = 0;
						if($i == 0)
						{
							$left = 0;
						} 
						else 
						{
							$left = round(100 / (count($item->answers) - 1) * $i, 4) - 2 ;
						}
						?>
						<div style="<?php echo $i < (count($item->answers) - 1) ? 'position: absolute; left: '.$left .'%' : '';?>"
							<?php echo $i == count($item->answers) - 1 ? ' class="pull-right"' : '';?>>
							<?php echo $this->escape($answer->title);?>
						</div>
						<?php 
					}
					?>
					</div>
				</td>
			</tr>
		</thead>
		<?php endif;?>
		<tbody>
			<tr>
				<td colspan="<?php echo count($item->answers);?>" style="padding: 10px;">
					<div class="slider-wrapper" 
						data-min="<?php echo count($item->answers) ? 0 : $item->params->get('slider_min_value');?>"
						data-max="<?php echo count($item->answers) ? count($item->answers) - 1 : $item->params->get('slider_max_value');?>"
						data-step="<?php echo count($item->answers) ? 1 : $item->params->get('slider_step_size');?>"></div>
					<div style="display: none;">
						<div class="answers"><?php echo count($item->answers) ? json_encode($answers) : '[]';?></div>
						<div class="inputs">
							<?php
							if(count($item->answers))
							{
								foreach ($item->answers as $answer)
								{
									$checked = '';
									$rules = '';
									foreach ($item->responses as $response)
									{
										if($answer->id == $response->answer_id)
										{
											$checked = ' checked="checked"';
										}
										else if(!empty($response->free_text))
										{
											$free_text = CjLibUtils::escape($response->free_text);
										}
									}
									
									if(isset($item->rule_selected[$answer->id]))
									{
										$rules = ' showitems="'.implode(',', $item->rule_selected[$answer->id]).'"';
									}
									?>
									<input type="radio" 
										name="answer-<?php echo $item->id;?>" 
										value="<?php echo $answer->id?>"<?php echo $checked;?> 
										class="margin-right-5<?php echo $required;?>"
										<?php echo $rules;?>>
									<?php 
								}
							}
							else
							{
								foreach ($item->responses as $response)
								{
									if(!empty($response->free_text))
									{
										$free_text = CjLibUtils::escape($response->free_text);
										break;
									}
								}
								?>
								<input type="text" name="free-text-<?php echo $item->id;?>" value="<?php echo $free_text;?>" class="<?php echo $required;?>">
								<?php 
							}
							?>
						</div>
					</div>
					
				</td>
			</tr>
		</tbody>
	</table>
</div>