<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 				= $displayData['item'];
$free_text 			= '';
$icon 				= $item->question_type == CS_CHOICE_CHECKBOX ? 'fa fa-square-o' : 'fa fa-circle-o';
?>
<ul class="list-group no-margin-left survey-result-question">
<?php
	foreach ($item->answers as $answer)
	{
		$selected = false;
		if(!empty($item->responses))
		{
			foreach ($item->responses as $response)
			{
				if($response->answer_id == $answer->id)
				{
					$selected = true;
				}
				elseif(!empty($response->free_text))
				{
					$free_text = $response->free_text;
				}
			}
		}
		?>
		<li class="list-group-item choice-answer<?php echo $selected ? ' selected-answer' : '';?>">
			<?php
			if($selected)
			{
				?>
				<i class="fa fa-check-square-o" data-toggle="tooltip" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_RESULT_YOUR_ANSWER');?>"></i>
				<?php
			}
			else
			{
				?>
				<i class="<?php echo $icon;?> text-muted"></i>
				<?php
			}
			
			echo $this->escape($answer->title);
			
			if($selected)
			{
				?>
				<span class="text-success">(<?php echo JText::_('COM_COMMUNITYSURVEYS_RESULT_YOUR_ANSWER')?>)</span>
				<?php
			}
			?>
		</li>
		<?php 
	}
	
	if(!empty($free_text))
	{
		?>
		<li class="<?php echo $item->orientation == 'IL' ? '' : 'list-group-item ';?>choice-answer"><?php echo $this->escape($free_text);?></li>
		<?php 
	}
	?>
</ul>