<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item = $displayData['item'];
?>
<div class="table-responsive">
	<table class="table table-hover table-bordered table-striped margin-bottom-20">
		<thead>
			<tr>
				<td></td>
				<?php 
				foreach($item->columns as $column)
				{
					?>
					<td class="center"><?php echo $this->escape($column->title);?></td>
					<?php 
				}
				?>
			</tr>
		<thead>
		<tbody>
			<?php
			foreach($item->answers as $answer)
			{
				if($answer->answer_type == 'x')
				{
					?>
					<tr>
						<td><?php echo $this->escape($answer->title);?></td>
						<?php
						foreach($item->columns as $column)
						{
							$selected = false;
							if(!empty($item->responses))
							{
								foreach ($item->responses as $response)
								{
									if($response->answer_id == $answer->id && $response->column_id == $column->id)
									{
										$selected = true;
									}
									else if(!empty($response->free_text))
									{
										$free_text = $response->free_text;
									}
								}
							}
							
							if($selected)
							{
								?>
								<td class="text-center">
									<i class="fa fa-check-square-o" data-toggle="tooltip" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_RESULT_YOUR_ANSWER');?>"></i>
								</td>
								<?php
							}
							else
							{
								?>
								<td class="text-center">
									<i class="fa fa-square-o"></i>
								</td>
								<?php
							}
						}
						?>
					</tr>
					<?php
				}
			}
			?>
		</tbody>
		<?php if(!empty($free_text)):?>
		<tfoot>
			<tr>
				<td><?php echo $this->escape($free_text);?></td>
			</tr>
		</tfoot>
		<?php endif;?>
	</table>
</div>