<?php 
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$params 	= $displayData['params'];
$state      = $displayData['state'];

$categories = JCategories::getInstance('CommunitySurveys', array('countItems'=>true));
$category 	= $categories->get($state->get('filter.category_id', 'root'));
$theme 		= $params->get('theme', 'default');
$layout 	= $params->get('ui_layout');
?>
<div class="card bg-<?php echo $theme;?> mb-3">
	<div class="card-header">
		<h5 class="card-title">
			<span><i class="fa fa-folder-open"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_CATEGORIES_LABEL');?></span>
			<?php if(!empty($category->parent_id)):?>
			<a href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getCategoryRoute($category));?>">
				<small>: <?php echo $this->escape($category->title). ($category->numitems ? ' ('.$category->numitems.')'  : '');?></small> 
			</a>
			<?php endif;?>
		</h5>
	</div>
	<div class="card-body">
		<?php 
		if ($params->get('list_show_category_list', 1) == 1 && !empty($category->id) && count($category->getChildren()) > 0)
		{
			echo SurveyHelper::renderLayout($layout.'.category_list', array('category'=>$category, 'params'=>$params, 'maxlevel'=>1));
		}
		
		if($params->get('list_show_search_form', 1) == 1)
		{
			echo SurveyHelper::renderLayout($layout.'.search_form', array('params'=>$params, 'state'=>$state, 'catid'=>(isset($category->id) ? $category->id : 0)));
		}
		?>
	</div>
</div>