<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$state		= isset($displayData['state']) ? $displayData['state'] : null;
$params 	= $displayData['params'];
$item 		= $displayData['item'];
$pages 		= $displayData['pages'];
$theme 		= $params->get('theme', 'default');
$editorName	= $params->get('default_editor', 'tinymce');
$editor     = $params->get('load_editor', true) ? JEditor::getInstance($editorName) : false;
?>

<div class="card bg-<?php echo $theme;?> mb-2 question" id="question-<?php echo $item->id?>">
	<div class="card-header" role="tab" id="heading-<?php echo $item->id;?>">
		<div class="pull-right question-controls">
			<span><small><?php echo '[ID: ' . $item->id . '] ';?></small></span>
			<a href="#" onclick="document.questionForm.id.value=<?php echo $item->id;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.remove', 'onBeforeDeleteQuestion', 'onAfterDeleteQuestion'); return false;" 
				title="<?php echo JText::_('JACTION_DELETE')?>" class="btn-delete-question" data-toggle="tooltip">
				<i class="fa fa-trash-o"></i>
			</a>
			<a href="#" onclick="document.questionForm.id.value=<?php echo $item->id;?>; return false;" 
				title="<?php echo JText::_('COM_COMMUNITYSURVEYS_MOVE_TO_ANOTHER_PAGE')?>" class="btn-move-question" data-toggle="tooltip">
				<i class="fa fa-share-square-o"></i>
			</a>
			<a href="#" onclick="document.questionForm.id.value=<?php echo $item->id;?>; return false;" 
				title="<?php echo JText::_('COM_COMMUNITYSURVEYS_COPY_TO_ANOTHER_PAGE')?>" class="btn-copy-question" data-toggle="tooltip">
				<i class="fa fa-copy"></i>
			</a>
			<a href="#" onclick="return false;" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_CLICK_DRAG_TO_SORT')?>" class="btn-sort-question" data-toggle="tooltip">
				<i class="fa fa-crosshairs"></i>
			</a>
		</div>
		<h4 class="card-title">
			<a class="question-title" data-toggle="collapse" data-parent="#questions" href="#question-body-<?php echo $item->id?>" aria-expanded="true" aria-controls="#question-body-<?php echo $item->id?>">
				<i class="<?php echo SurveyHelper::getQuestionIcon($item->question_type);?>"></i> <?php echo $this->escape($item->title);?>
			</a>
		</h4>
	</div>
	<div id="question-body-<?php echo $item->id?>" class="collapse" data-parent="#questions" role="tabpanel" aria-labelledby="heading-<?php echo $item->id;?>">
		<div class="card-body p-0 border-0">
			<form action="<?php echo JRoute::_('index.php?option=com_communitysurveys')?>" method="post" name="qForm" id="qForm<?php echo $item->id?>" class="no-margin-bottom">
				<?php
				$layouts = array(
						CS_PAGE_HEADER => 'page_header',
						CS_CHOICE_RADIO => 'radio',
						CS_CHOICE_CHECKBOX => 'checkbox',
						CS_CHOICE_SELECT => 'select',
						CS_CHOICE_MULTIRATING => 'multirating',
						CS_CHOICE_RANKING => 'ranking',
						CS_CHOICE_NPS => 'nps',
						CS_CHOICE_SLIDER => 'slider',
						CS_GRID_RADIO => 'radio_grid',
						CS_GRID_CHECKBOX => 'checkbox_grid',
						CS_FREE_TEXT_SINGLE_LINE => 'textbox',
						CS_FREE_TEXT_MULTILINE => 'textarea',
						CS_FREE_TEXT_PASSWORD => 'password',
						CS_FREE_TEXT_RICH_TEXT => 'rich_textbox',
						CS_IMAGE_CHOOSE_IMAGE => 'image_radio',
						CS_IMAGE_CHOOSE_IMAGES => 'image_checkbox',
						CS_GRID_MATCHING => 'matching',
						CS_FILE_UPLOAD => 'fileupload',
						CS_SPECIAL_NAME => 'name',
						CS_SPECIAL_EMAIL => 'email',
						CS_SPECIAL_CALENDAR => 'calendar',
						CS_SPECIAL_ADDRESS => 'address',
						CS_SPECIAL_SIGNATURE => 'signature'
				);
				
				echo $this->sublayout($layouts[$item->question_type], array('item'=>$item, 'pages'=>$pages, 'params'=>$params, 'state'=>$state, 'editor'=>$editor));
				?>
				<input type="hidden" name="task" value="" />
				<input type="hidden" name="answers" value="" />
				<input type="hidden" name="columns" value="" />
				<input type="hidden" name="survey_id" value="<?php echo $item->survey_id;?>" />
				<input type="hidden" name="rule_id" value="" />
				<input type="hidden" name="qid" value="<?php echo $item->id;?>" />
				<input type="hidden" name="pid" value="<?php echo $item->page_number;?>" />
				<input type="hidden" name="qtype" value="<?php echo $item->question_type;?>" />
				<?php echo JHtml::_('form.token'); ?>
			</form>
		</div>
	</div>
	
	<div class="tpl-delete-rule" style="display: none;">
		<a href="#" class="delete-rule" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_DELETE_RULE');?>" data-toggle="tooltip" 
			onclick="CjSurveyApi.submitAjaxForm(this, '#qForm<?php echo $item->id?>', 'question.deleterule', 'onBeforeDeleteRule', 'onAfterDeleteRule'); return false;"> 
			<i class="fa fa-trash-o"></i> <?php echo JText::_('JACTION_DELETE');?>
		</a>
		<input type="hidden" name="item_rule_id" value="">
	</div>
</div>