<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 		= $displayData['item'];
$editor 	= $displayData['editor'];
?>
<div class="question-tabs" role="tabpanel">
	<ul class="nav nav-tabs" role="tablist" id="qntab-<?php echo $item->id;?>">
		<li class="nav-item mr-auto" role="presentation">
			<a class="nav-link active show" href="#content-<?php echo $item->id?>" aria-controls="#content-<?php echo $item->id?>" role="tab" data-toggle="tab" onclick="return false;">
				<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_CONTENT');?>
			</a>
		</li>
		<li class="nav-item">
			<a class="nav-link" href="javascript: void();" onclick="CjSurveyApi.submitAjaxForm(this, '#qForm<?php echo $item->id?>', 'question.save', 'onBeforeSaveQuestion', 'onAfterSaveQuestion')">
				<?php echo JText::_('JSAVE');?>
			</a>
		</li>
		<li class="nav-item">
			<a class="nav-link btn-close-question" href="javascript: void();"><?php echo JText::_('JCANCEL');?></a>
		</li>
	</ul>
	<div class="tab-content">
		<div role="tabpanel" class="tab-pane active show" id="content-<?php echo $item->id?>">
			<div class="form-group">
				<label for="title-<?php echo $item->id;?>"><?php echo JText::_('JGLOBAL_TITLE');?><sup>*</sup>:</label>
				<input type="text" name="title" id="title-<?php echo $item->id;?>" value="<?php echo $this->escape($item->title);?>" class="form-control required">
			</div>
			<div class="form-group<?php echo $params->get('load_editor') ? '' : ' js-editor-tinymce';?>">
				<label for="description_<?php echo $item->id;?>"><?php echo JText::_('JGLOBAL_DESCRIPTION');?>:</label>
				<?php echo SurveyHelper::loadEditor($editor, 'description_'.$item->id, 'description', $item->description, '100%');?>
			</div>
		</div>
	</div>
</div>
