<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item       = $displayData['item'];
$questions  = $displayData['questions'];
$pages      = $displayData['pages'];
$params     = $displayData['params'];
$pageId     = $displayData['pageId'];
$state      = $displayData['state'];

$layout     = $params->get('ui_layout', 'default');
$theme      = $params->get('theme', 'default');
?>
<div id="survey-main-wrapper" class="survey-main-wrapper">
	<div class="navbar navbar-expand-md navbar-light bg-light sticky-top mb-3">
		<a class="brand navbar-brand hidden-phone hidden-xs" href="#" onclick="return false;"><i class="fa fa-wrench"></i></a>
		<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarTogglerQuestions" aria-controls="navbarTogglerQuestions" aria-expanded="false" aria-label="Toggle navigation">
			<span class="navbar-toggler-icon"></span>
    	</button>

		<div class="collapse navbar-collapse" id="navbarTogglerQuestions">
			<ul class="navbar-nav mr-auto mt-2 mt-lg-0">
				<li class="nav-item dropdown">
					<a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown"><?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_GROUP_CHOICE');?> <b class="caret"></b></a>
					<ul class="dropdown-menu">
						<li class="nav-header"><?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_GROUP_MULTIPLE_CHOICE');?></li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-radio" onclick="document.questionForm.qtype.value=<?php echo CS_CHOICE_RADIO;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-dot-circle-o"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_CHOICE_RADIO');?>
							</a>
						</li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-checkbox" onclick="document.questionForm.qtype.value=<?php echo CS_CHOICE_CHECKBOX;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-check-square-o"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_CHOICE_CHECKBOX');?>
							</a>
						</li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-select" onclick="document.questionForm.qtype.value=<?php echo CS_CHOICE_SELECT;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-hand-o-up"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_CHOICE_SELECT');?>
							</a>
						</li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-multirating" onclick="document.questionForm.qtype.value=<?php echo CS_CHOICE_MULTIRATING;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-star"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_CHOICE_MULTIRATING');?>
							</a>
						</li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-ranking" onclick="document.questionForm.qtype.value=<?php echo CS_CHOICE_RANKING;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-sort-numeric-asc"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_CHOICE_RANKING');?>
							</a>
						</li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-slider" onclick="document.questionForm.qtype.value=<?php echo CS_CHOICE_SLIDER;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-sliders"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_SLIDER');?>
							</a>
						</li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-nps" onclick="document.questionForm.qtype.value=<?php echo CS_CHOICE_NPS;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-tachometer"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_NPS');?>
							</a>
						</li>
						
						<li role="separator" class="divider"></li>
						
						<li class="nav-header"><?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_GROUP_GRID');?></li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-grid-radio" onclick="document.questionForm.qtype.value=<?php echo CS_GRID_RADIO;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-th-large"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_GRID_RADIO');?>
							</a>
						</li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-grid-radio" onclick="document.questionForm.qtype.value=<?php echo CS_GRID_CHECKBOX;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-th"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_GRID_CHECKBOX');?>
							</a>
						</li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-matching" onclick="document.questionForm.qtype.value=<?php echo CS_GRID_MATCHING;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-list-ol"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_GRID_MATCHING');?>
							</a>
						</li>
						<li role="separator" class="divider"></li>
						<li class="nav-header"><?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_GROUP_IMAGES');?></li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-image" onclick="document.questionForm.qtype.value=<?php echo CS_IMAGE_CHOOSE_IMAGE;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-picture-o"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_CHOOSE_IMAGE');?>
							</a>
						</li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-images" onclick="document.questionForm.qtype.value=<?php echo CS_IMAGE_CHOOSE_IMAGES;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-film"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_CHOOSE_IMAGES');?>
							</a>
						</li>
					</ul>
				</li>
				<li class="nav-item dropdown">
					<a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown"><?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_GROUP_FREETEXT');?> <b class="caret"></b></a>
					<ul class="dropdown-menu">
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-singleline" onclick="document.questionForm.qtype.value=<?php echo CS_FREE_TEXT_SINGLE_LINE;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-minus"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_FREETEXT_SINGLE_LINE');?>
							</a>
						</li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-multiline" onclick="document.questionForm.qtype.value=<?php echo CS_FREE_TEXT_MULTILINE;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-align-justify"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_FREETEXT_MULTI_LINE');?>
							</a>
						</li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-password" onclick="document.questionForm.qtype.value=<?php echo CS_FREE_TEXT_PASSWORD;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-qrcode"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_FREETEXT_PASSWORD');?>
							</a>
						</li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-richtext" onclick="document.questionForm.qtype.value=<?php echo CS_FREE_TEXT_RICH_TEXT;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-file"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_FREETEXT_RICHTEXT');?>
							</a>
						</li>
					</ul>
				</li>
				<li class="nav-item dropdown">
					<a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown"><?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_GROUP_SPECIAL');?> <b class="caret"></b></a>
					<ul class="dropdown-menu">
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-header" onclick="document.questionForm.qtype.value=<?php echo CS_PAGE_HEADER;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-magnet"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_PAGE_HEADER');?>
							</a>
						</li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-fileupload" onclick="document.questionForm.qtype.value=<?php echo CS_FILE_UPLOAD;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-upload"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_FILE_UPLOAD');?>
							</a>
						</li>
						<li role="separator" class="divider"></li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-header" onclick="document.questionForm.qtype.value=<?php echo CS_SPECIAL_NAME;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-user"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_NAME');?>
							</a>
						</li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-header" onclick="document.questionForm.qtype.value=<?php echo CS_SPECIAL_SIGNATURE;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-pencil-square-o"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_SIGNATURE');?>
							</a>
						</li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-fileupload" onclick="document.questionForm.qtype.value=<?php echo CS_SPECIAL_EMAIL;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-envelope"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_EMAIL');?>
							</a>
						</li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-header" onclick="document.questionForm.qtype.value=<?php echo CS_SPECIAL_CALENDAR;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-calendar"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_CALENDAR');?>
							</a>
						</li>
						<li class="dropdown-item">
							<a class="nav-link" href="#" id="qntype-fileupload" onclick="document.questionForm.qtype.value=<?php echo CS_SPECIAL_ADDRESS;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-home"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_ADDRESS');?>
							</a>
						</li>
					</ul>
				</li>
			</ul>
		</div>
	</div>
	
	<div class="alert alert-info">
		<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
		<i class="fa fa-info-circle"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_FORM_HELP');?>
	</div>
	
	<div class="card card-<?php echo $theme?> mb-3">
		<div class="card-header">
			<div class="form-inline">
                <div class="mr-auto">
        			<select name="pageid" size="1" class="form-control">
        				<?php 
        				if(!empty($pages))
        				{
        					foreach ($pages as $page)
        					{
        						?>
        						<option value="<?php echo $page->id;?>"<?php $pageId == $page->id ? ' selected="selected"' : '';?>>
        							<?php echo JText::sprintf('COM_COMMUNITYSURVEYS_PAGE_TITLE_LABEL', $page->title, array('jsSafe'=>true)).' (ID: '.$page->id.')';?>
        						</option>
        						<?php
        					}
        				}
        				?>
        			</select>
    			
        			<div class="btn-group">
        				<button type="button" class="btn btn-default btn-sm btn-edit-page-title" data-toggle="tooltip" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_EDIT_PAGE_TITLE');?>">
        					<i class="fa fa-pencil"></i>
        				</button>
        				<button type="button" class="btn btn-success btn-sm" data-toggle="tooltip" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_ADD_NEW_PAGE');?>"
        					onclick="document.questionForm.pid.value=0;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.addpage', 'onBeforeAddPage', 'onAfterAddPage'); return false;">
        					<i class="fa fa-plus-circle"></i>
        				</button>
        				<button type="button" class="btn btn-danger btn-sm" data-toggle="tooltip" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_DELETE_PAGE');?>"
        					onclick="CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.deletepage', 'onBeforeDeletePage', 'onAfterDeletePage'); return false;">
        					<i class="fa fa-trash-o"></i>
        				</button>
        			</div>
        			
        			<button type="button" class="btn btn-default btn-sm btn-reorder-pages" data-toggle="tooltip" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_REORDER_PAGES');?>">
    					<i class="fa fa-cogs"></i>
    				</button>
        		</div>
                <div class="ml-3">
                	<a href="#PreviewQuestionsModal" data-toggle="modal" class="btn btn-default btn-small btn-sm">
                        <i class="fa fa-eye"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_PREVIEW_QUESTIONS');?>
                    </a>
                    <?php 
                    echo JHtml::_(
                    		'bootstrap.renderModal',
                    		'PreviewQuestionsModal',
                    		array(
                    				'title'       => JText::_('COM_COMMUNITYSURVEYS_PREVIEW_QUESTIONS'),
                    				'backdrop'    => 'static',
                    				'keyboard'    => true,
                    				'closeButton' => true,
                    				'url'         => JRoute::_('index.php?option=com_communitysurveys&view=form&layout=preview&s_id='.$item->id),
                    				'height'      => '400px',
                    				'width'       => '800px',
                    				'bodyHeight'  => '70',
                    				'modalWidth'  => '80',
                    				'footer'      => '',
                    		)
                    	);
                    ?>
                    <a href="<?php echo JRoute::_('index.php?option=com_communitysurveys&task=survey.publish&id='.$item->id);?>" class="btn btn-primary btn-small btn-sm">
                        <i class="fa fa-check"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_PUBLISH_SURVEY');?>
                    </a>
                </div>
    		</div>
		</div>
	</div>
	
	<div class="questions" id="questions" role="tablist" aria-multiselectable="true">
		<?php 
		if(!empty($questions))
		{
			foreach ($questions as $question)
			{
				echo SurveyHelper::renderLayout($layout.'.form.question', array('item'=>$question, 'pages'=>$pages, 'params'=>$params, 'state'=>$state), '', array('debug' => false));
			}
		}	
		?>
	</div>
</div>

<div id="modalMoveQuestion" class="modal fade" style="display: none;">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title"><?php echo JText::_('COM_COMMUNITYSURVEYS_MOVE_QUESTION_TO_PAGE')?></h4>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			</div>
			<div class="modal-body p-3">
				<p class="move-question-text"></p>
				<p><?php echo JText::_('COM_COMMUNITYSURVEYS_SELECT_PAGE_TO_MOVE');?></p>
				<select name="all-pages" class="col-md-6"></select>
				<br><br><br><br>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal"><?php echo JText::_('JCANCEL');?></button>
				<button type="button" class="btn btn-primary btn-confirm-move-question"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_CONFIRM_MOVE')?></button>
				<button type="button" class="btn btn-primary btn-confirm-copy-question"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_CONFIRM_COPY')?></button>
			</div>
		</div>
	</div>
</div>

<div id="modalReorderPages" class="modal fade" style="display: none;">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title"><?php echo JText::_('COM_COMMUNITYSURVEYS_REORDER_PAGES')?></h4>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			</div>
			<div class="modal-body" style="padding: 1%;">
				<ul class="list-group reorder-pages-list" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_CLICK_DRAG_TO_SORT')?>" class="btn-sort-page" data-toggle="tooltip" style="width: 80%;">
				<?php 
				if(!empty($pages))
				{
					foreach ($pages as $page)
					{
						?>
						<li class="list-group-item sortpage">
							<i class="fa fa-crosshairs"></i> <?php echo JText::sprintf('COM_COMMUNITYSURVEYS_PAGE_TITLE_LABEL', $page->title, array('jsSafe'=>true)).' (ID: '.$page->id.')';?>
							<input type="hidden" name="sortpageid" value="<?php echo $page->id;?>">
						</li>
						<?php
					}
				}
				?>
				</ul>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal"><?php echo JText::_('JCANCEL');?></button>
				<button type="button" class="btn btn-primary btn-corfirm-reorder-pages"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_REORDER')?></button>
			</div>
		</div>
	</div>
</div>
