<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

JHtml::_('formbehavior.chosen', 'select');

$document	= JFactory::getDocument();
$data		= $displayData['data'];
$browsers	= $data->report;

if($browsers && count($browsers) > 0)
{
	
	$document->addScript('https://www.google.com/jsapi');
	$document->addScriptDeclaration('google.load("visualization", "1", {packages:["geochart"]});');
	$document->addStyleSheet(CJLIB_MEDIA_URI.'/datatables/datatables.min.css');
	$document->addScript(CJLIB_MEDIA_URI.'/datatables/datatables.min.js');
	?>
	<script type="text/javascript">
	jQuery(document).ready(function($)
	{
	    var table = $('#browsers-table').DataTable({
	        bLengthChange: true, 
	        paging: false,
	        dom: 'Bfrtip',
	        buttons: ['copy', 'excel', 'pdf'],
			columnDefs: [{ visible: false, targets: 0 }],
			order: [[ 0, 'asc' ]],
			displayLength: 25,
			stateSave: false,
			stateDuration: 60*60*24*365,
			drawCallback: function ( settings ) 
			{
				var api = this.api();
				var rows = api.rows( {page:'current'} ).nodes();
				var last=null;
				var colonne = api.row(0).data().length;
	            var total = new Array();
	            total['total']= new Array();
	            var groupid = -1;
	            var subtotal = new Array();
	
				api.column(0, {page:'current'} ).data().each( function ( group, i ){
					if ( last !== group ) 
					{
						var groupRow = $('<tr class="group"><td class="info"><i class="fa fa-plus-square-o"></i> '+group+'</td></tr>');
						$(rows).eq( i ).before(groupRow);
						last = group;
						groupid++;
						
						groupRow.click(function()
						{
							$(this).nextUntil('.group').toggleClass('hide');
							$(this).find('i').toggleClass('fa-minus-square-o').toggleClass('fa-plus-square-o');
						}).nextUntil('.group').addClass('hide');
					}
	
					val = api.row(api.row($(rows).eq( i )).index()).data(); 
	                $.each(val, function(index2, val2){
	                	if (typeof subtotal[groupid] =='undefined')
		                {
		                	subtotal[groupid] = new Array();
		                }
		                if (typeof subtotal[groupid][index2] =='undefined')
						{
							subtotal[groupid][index2] = 0;
						}
						if (typeof total['total'][index2] =='undefined')
						{ 
							total['total'][index2] = 0; 
						}
						if(!isNaN(val2))
						{
							subtotal[groupid][index2] += Number(val2);
							total['total'][index2] += Number(val2);
						}
						else
						{
							subtotal[groupid][index2] = 'a';
							total['total'][index2] = 'a';
						}
	                });
				});
	
				$('tbody').find('.group').each(function (i,v){
					var rowCount = $(this).nextUntil('.group').length;
					$(this).find('td:first').append($('<span />', { 'class': 'rowCount-grid' }).append($('<small />', { 'text': ' ('+rowCount+')' })));
					var subtd = '';
					
					for (var a = 2; a < colonne; a++)
					{
						totals = '';
						if(!isNaN(subtotal[i][a]))
						{
							totals = subtotal[i][a]+' / '+total['total'][a]+ ' ('+ Math.round(subtotal[i][a]*100/total['total'][a],2) + '%)';
						}
						subtd += '<td class="info"><small class="text-muted">'+totals+'</small></td>';
					}
					$(this).append(subtd);
				});
			}
		})
	    $('.browsers-report select').addClass('input-mini input-xs').chosen();
	});
	</script>
	
	<div class="browsers-report">
		<div class="table-responsive">
			<table class="table table-striped table-hover table-condensed" id="browsers-table">
				<thead>
					<tr>
						<th><?php echo JText::_('COM_COMMUNITYSURVEYS_BROWSER');?></th>
						<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_PLATFORM');?></th>
						<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_VERSION');?></th>
						<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_RESPONSES');?></th>
					</tr>
				</thead>
				<tbody>
					<?php 
					foreach ($browsers as $i=>$browser)
					{
						?>
						<tr>
							<td><?php echo $this->escape($browser['browser']);?></td>
							<td><?php echo $browser['platform'];?></td>
							<td><?php echo $this->escape($browser['browser']) .' '. $this->escape($browser['version']);?></td>
							<td><?php echo $browser['count'];?></td>
						</tr>
						<?php 
					}
					?>
				</tbody>
			</table>
		</div>
	</div>
	<?php 
}
else 
{
	?>
	<p class="alert alert-info"><i class="fa fa-info-circle"></i> <?php echo JText::_('JGLOBAL_NO_MATCHING_RESULTS');?></p>
	<?php
}
?>