<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 				= $displayData['item'];

if(!empty($item->textResponses))
{
	?>
	<table class="table table-striped table-hover">
		<thead>
			<tr>
				<th width="25%"><?php echo JText::_('JGLOBAL_USERNAME');?></th>
				<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ANSWER');?></th>
			</tr>
		</thead>
		<tbody>
		<?php
		$route = CommunitySurveysHelperRoute::getResponsesRoute();
		foreach ($item->textResponses as $response)
		{
			?>
			<tr>
				<td><?php echo !empty($response->author) ? $this->escape($response->author) : JText::_('COM_COMMUNITYSURVEYS_GUEST');?></td>
				<td>
					<a href="<?php echo JRoute::_($route.'&task=response.downloadfile&qid='.$item->id.'&rid='.$response->response_id);?>" target="_blank">
				    	<i class="fa fa-download"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_DOWNLOAD_FILE');?>
                	</a>
                </td>
			</tr>
			<?php
		}
		?>
		</tbody>
	</table>
	<?php
}
else
{
    ?>
    <div class="card-body"><?php echo JText::_('COM_COMMUNITYSURVEYS_NO_ANSWER_PROVIDED');?></div>
    <?php
}
?>
