<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$data				= $displayData['data'];
$params 			= $data->item->params;
$pagination			= $data->pagination;
$numPages			= !empty($pagination) ? count($pagination->getPages()) : 0;
$currPageNum		= !empty($pagination) ? $pagination->getCurrPageNum() : 1;
$progress			= $numPages > 0 ? round($currPageNum * 100 / $numPages): 0;

if($params->get('show_survey_page_title'))
{
    $pages = $pagination->getPages();
    foreach ($pages as $i=>$page)
    {
        if($pagination->getActivePageId() == $page->id)
        {
            ?>
            <h3 class="page-header mb-3"><?php echo $this->escape($page->title);?></h3>
            <?php 
            break;
        }
    }
}

if($numPages > 1 && ($params->get('show_pagination') || $params->get('show_jumptopage')) )
{
	?>
	<div class="row">
		<div class="col-md-12 margin-bottom-10">
			<?php 
			if($params->get('show_jumptopage'))
			{
				$pages = $pagination->getPages();
				?>
				<div class="pull-right margin-left-10">
					<select name="jumptopageid" size="1">
						<option><?php echo JText::_('COM_COMMUNITYSURVEYS_JUMP_TO_PAGE');?></option>
						<?php foreach ($pages as $i=>$page):?>
						<option value="<?php echo $page->id?>"<?php echo $pagination->getActivePageId() == $page->id ? ' disabled="disabled"' : '';?>>
							<?php echo !empty($page->title) ? $this->escape($page->title) : JText::sprintf('COM_COMMUNITYSURVEYS_PAGE_TITLE_LABEL', $i + 1);?>
						</option>
						<?php endforeach;?>
					</select>
				</div>
				<?php
			}
			?>
			
			<div class="survey-pagination">
	    		<div class="progress">
	    			<div class="progress-bar progress-bar-striped active" role="progressbar" 
	    				aria-valuenow="<?php echo $progress?>" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo $progress?>%"></div>
	    		</div>
	    		<div class="margin-top-5 text-center">
	    			<small><?php echo JText::sprintf('COM_COMMUNITYSURVEYS_PAGE_NO', $currPageNum, $numPages)?></small>
	    		</div>
	    	</div>
	    </div>
	</div>
	<?php 
}