<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 				= $displayData['item'];
$free_text 			= '';
$required			= $item->mandatory ? ' required' : '';
$language           = JFactory::getLanguage()->getTag();
$language           = substr($language, 0, strpos($language, '-'));
?>
<ul class="list-group no-margin-left">
	<li class="list-group-item">
		<?php 
		foreach ($item->responses as $response)
		{
			if(!empty($response->free_text))
			{
				$free_text = $this->escape($response->free_text);
				break;
			}
		}
		?>
		<div class="row">
			<div class='col-sm-4'>
				<div class="form-group">
					<div class="input-group datetime">
						<input type="text" name="free-text-<?php echo $item->id;?>" class="form-control<?php echo $required;?>"
							value="<?php echo $free_text;?>" placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_ENTER_YOUR_ANSWER');?>"
							aria-label="<?php echo JText::_('COM_COMMUNITYSURVEYS_ENTER_YOUR_ANSWER');?>"
							data-language="<?php echo $language;?>"
							<?php echo !empty($item->params->get('min_date')) ? 'data-mindate="'.$this->escape($item->params->get('min_date')).'"' : '';?>
							<?php echo !empty($item->params->get('max_date')) ? 'data-maxdate="'.$this->escape($item->params->get('max_date')).'"' : '';?>
							data-format="<?php echo $item->params->get('date_format', 'Y-m-d H:i:s')?>">
						<span class="input-group-addon"><span class="fa fa-calendar"></span></span>
					</div>
				</div>
			</div>
		</div>
	</li>
</ul>